/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.utils;

import com.badlogic.gdx.Gdx;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Entitys.College;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Managers.GameManager;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public final class SaveObject {
    public static void writeXMl(String path) {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(new FileOutputStream(path));
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeStartElement("SAVE");
            xMLStreamWriter.writeStartElement("Ships");
            xMLStreamWriter.writeAttribute("Number", "value");
            int i = 0;
            for (Ship s : GameManager.ships) {
                SaveObject.writeShiptoXML(xMLStreamWriter, s, i);
                ++i;
            }
            i = 0;
            xMLStreamWriter.writeEndElement();
            for (College c : GameManager.colleges) {
                SaveObject.writeCollegeToXML(xMLStreamWriter, c, i);
                ++i;
            }
            Player p = GameManager.getPlayer();
            SaveObject.writeGamedatatoXML(xMLStreamWriter, p);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            stringWriter.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeShiptoXML(XMLStreamWriter xmlDoc, Ship ship, int index) throws XMLStreamException {
        xmlDoc.writeStartElement("position");
        xmlDoc.writeStartElement("X");
        xmlDoc.writeCharacters(String.valueOf(ship.getPosition().x));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Y");
        xmlDoc.writeCharacters(String.valueOf(ship.getPosition().y));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Index");
        xmlDoc.writeCharacters(String.valueOf(index));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Health");
        xmlDoc.writeCharacters(String.valueOf(ship.getHealth()));
        xmlDoc.writeEndElement();
        xmlDoc.writeEndElement();
    }

    private static void writeCollegeToXML(XMLStreamWriter xmlDoc, College college, int index) throws XMLStreamException {
        xmlDoc.writeStartElement("College");
        xmlDoc.writeStartElement("Name");
        xmlDoc.writeCharacters(String.valueOf(college.getName()));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Alive");
        xmlDoc.writeCharacters(String.valueOf(college.isAlive()));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Index");
        xmlDoc.writeCharacters(String.valueOf(index));
        xmlDoc.writeEndElement();
        xmlDoc.writeEndElement();
    }

    private static void writeGamedatatoXML(XMLStreamWriter xmlDoc, Player player) throws XMLStreamException {
        xmlDoc.writeStartElement("GAMEDATA");
        xmlDoc.writeStartElement("Ammo");
        xmlDoc.writeCharacters(String.valueOf(player.getAmmo()));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Plunder");
        xmlDoc.writeCharacters(String.valueOf(player.getPlunder()));
        xmlDoc.writeEndElement();
        xmlDoc.writeStartElement("Points");
        xmlDoc.writeCharacters(String.valueOf(player.getComponent(Pirate.class).getPoints()));
        xmlDoc.writeEndElement();
        xmlDoc.writeEndElement();
    }

    public static void readXML(String path) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = path == "restart.xml" ? factory.createXMLEventReader(Gdx.files.internal("restart.xml").reader()) : factory.createXMLEventReader(new FileReader(path));
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        String qName = startElement.getName().getLocalPart();
                        if (qName.equalsIgnoreCase("ships")) break;
                        if (qName.equalsIgnoreCase("position")) {
                            SaveObject.placeShip(eventReader);
                            break;
                        }
                        if (qName.equalsIgnoreCase("GAMEDATA")) {
                            SaveObject.loadGameData(eventReader);
                            break;
                        }
                        if (!qName.equalsIgnoreCase("College")) break;
                        SaveObject.loadCollege(eventReader);
                        break;
                    }
                    case 4: {
                        Characters characters = event.asCharacters();
                        System.out.println(characters.getData());
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static void placeShip(XMLEventReader eventReader) throws XMLStreamException {
        SaveObject.Next(eventReader);
        XMLEvent event = eventReader.nextEvent();
        Characters chars = event.asCharacters();
        float x = Float.parseFloat(chars.getData());
        SaveObject.Next(eventReader);
        event = eventReader.nextEvent();
        chars = event.asCharacters();
        float y = Float.parseFloat(chars.getData());
        SaveObject.Next(eventReader);
        event = eventReader.nextEvent();
        chars = event.asCharacters();
        int index = Integer.parseInt(chars.getData());
        SaveObject.Next(eventReader);
        event = eventReader.nextEvent();
        chars = event.asCharacters();
        int health = Integer.parseInt(chars.getData());
        GameManager.ships.get(index).setPosition(Float.valueOf(x), Float.valueOf(y));
        GameManager.ships.get(index).setHealth(health);
        if (health <= 0) {
            GameManager.ships.get(index).ShipDeath();
        }
    }

    private static void loadCollege(XMLEventReader eventReader) throws XMLStreamException {
        SaveObject.Next(eventReader);
        XMLEvent event = eventReader.nextEvent();
        Characters chars = event.asCharacters();
        String college_name = chars.getData();
        SaveObject.Next(eventReader);
        event = eventReader.nextEvent();
        chars = event.asCharacters();
        Boolean alive = Boolean.parseBoolean(chars.getData());
        SaveObject.Next(eventReader);
        event = eventReader.nextEvent();
        chars = event.asCharacters();
        Integer index = Integer.parseInt(chars.getData());
        if (!alive.booleanValue()) {
            GameManager.colleges.get(index).kill();
        }
    }

    private static void Next(XMLEventReader eventReader) throws XMLStreamException {
        while (!eventReader.peek().isCharacters()) {
            eventReader.nextEvent();
        }
    }

    private static void loadGameData(XMLEventReader eventReader) throws XMLStreamException {
        while (!eventReader.peek().isCharacters()) {
            eventReader.nextEvent();
        }
        XMLEvent event = eventReader.nextEvent();
        Characters chars = event.asCharacters();
        int ammo = Integer.parseInt(chars.getData());
        GameManager.getPlayer().setAmmo(ammo);
        while (!eventReader.peek().isCharacters()) {
            eventReader.nextEvent();
        }
        event = eventReader.nextEvent();
        chars = event.asCharacters();
        int plunder = Integer.parseInt(chars.getData());
        GameManager.getPlayer().plunder(plunder);
        SaveObject.Next(eventReader);
        event = eventReader.nextEvent();
        GameManager.getPlayer().getComponent(Pirate.class).points = Integer.parseInt(event.asCharacters().getData());
    }
}

