/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.desktop;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.mygdx.game.PirateGame;
import com.mygdx.utils.Constants;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class DesktopLauncher {
    public static void main(String[] arg) {
        if (DesktopLauncher.restartJVM()) {
            return;
        }
        Constants.INIT_CONSTANTS();
        Lwjgl3ApplicationConfiguration cfg = new Lwjgl3ApplicationConfiguration();
        cfg.setTitle(Constants.VIEWPORT_TITLE);
        if (Constants.FULLSCREEN) {
            cfg.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
        } else {
            cfg.setWindowedMode(Constants.VIEWPORT_WIDTH, Constants.VIEWPORT_HEIGHT);
        }
        new Lwjgl3Application(new PirateGame(), cfg);
    }

    public static boolean restartJVM() {
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Mac") && !osName.startsWith("Darwin")) {
            return false;
        }
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        String env = System.getenv("JAVA_STARTED_ON_FIRST_THREAD_" + pid);
        if (env != null && env.equals("1")) {
            return false;
        }
        String separator = System.getProperty("file.separator");
        String classpath = System.getProperty("java.class.path");
        String mainClass = System.getenv("JAVA_MAIN_CLASS_" + pid);
        String jvmPath = System.getProperty("java.home") + separator + "bin" + separator + "java";
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add(jvmPath);
        jvmArgs.add("-XstartOnFirstThread");
        jvmArgs.addAll(inputArguments);
        jvmArgs.add("-cp");
        jvmArgs.add(classpath);
        jvmArgs.add(mainClass);
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(jvmArgs);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            process.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

