/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.PirateGame;
import com.mygdx.game.UI.GameScreen;
import com.mygdx.game.UI.Page;
import com.mygdx.utils.Constants;

public class ShopScreen
extends Page {
    private float accumulator;

    public ShopScreen(PirateGame parent) {
        super(parent);
    }

    @Override
    public void render(float delta) {
        if (Gdx.input.isKeyJustPressed(111)) {
            this.parent.setScreen(this.parent.game);
        }
        super.render(delta);
    }

    @Override
    protected void update() {
        super.update();
        Player p = GameManager.getPlayer();
        GameScreen.healthLabel.setText(String.valueOf(p.getHealth()));
        GameScreen.dosh.setText(String.valueOf(p.getPlunder()));
        GameScreen.ammo.setText(String.valueOf(p.getAmmo()));
    }

    @Override
    protected void CreateActors() {
        Table t = new Table();
        t.setFillParent(true);
        float space = (float)Constants.VIEWPORT_HEIGHT * 0.05f;
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("shopBG.jpg")));
        Label l = new Label((CharSequence)"Shop", this.parent.skin);
        l.setFontScale(2.0f);
        t.add(l).top().spaceBottom(space * 0.5f);
        t.row();
        TextButton buyAmmo = new TextButton("Buy Ammo", this.parent.skin);
        buyAmmo.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (Pirate.plunder >= 10) {
                    Pirate.ammo += 10;
                    Pirate.plunder -= 10;
                }
            }
        });
        t.add(buyAmmo).size(100.0f, 25.0f).top().spaceBottom(10.0f);
        t.row();
        t.add(new Label((CharSequence)"Buy 10 cannons for 10 coins", this.parent.skin)).spaceBottom(10.0f);
        t.row();
        t.add(new Image(this.parent.skin, "ball")).top().left();
        t.add(new Label((CharSequence)"10", this.parent.skin)).right().spaceBottom(space);
        t.row();
        TextButton buyPowerups = new TextButton("Powerups", this.parent.skin);
        buyPowerups.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ShopScreen.this.parent.setScreen(ShopScreen.this.parent.powerup);
            }
        });
        t.add(buyPowerups).size(100.0f, 25.0f).top().spaceBottom(10.0f);
        t.row();
        t.add(new Label((CharSequence)"Continue to the powerup page", this.parent.skin)).spaceBottom(space);
        t.row();
        TextButton back = new TextButton("Return", this.parent.skin);
        back.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ShopScreen.this.parent.setScreen(ShopScreen.this.parent.game);
            }
        });
        t.add(back).top().size(100.0f, 25.0f).spaceBottom(space);
        t.top();
        this.actors.add(t);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        Table t = (Table)this.actors.get(0);
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("shopBG.jpg")));
    }
}

