/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.mygdx.game.Managers.DifficultyManager;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.PirateGame;
import com.mygdx.game.UI.Page;
import com.mygdx.utils.Constants;
import com.mygdx.utils.SaveObject;
import java.io.File;
import javax.swing.JFileChooser;

public class QuitConfirmationScreen
extends Page {
    public QuitConfirmationScreen(PirateGame parent) {
        super(parent);
    }

    @Override
    public void render(float delta) {
        if (Gdx.input.isKeyJustPressed(111)) {
            this.parent.setScreen(this.parent.game);
        }
        super.render(delta);
    }

    @Override
    protected void update() {
        super.update();
    }

    @Override
    protected void CreateActors() {
        Table t = new Table();
        t.setFillParent(true);
        float space = (float)Constants.VIEWPORT_HEIGHT * 0.05f;
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("menuBG.jpg")));
        Label l = new Label((CharSequence)"Ending Game", this.parent.skin);
        l.setFontScale(2.0f);
        t.add(l).top().spaceBottom(space * 0.5f);
        t.row();
        t.row();
        t.add(new Label((CharSequence)"Are you sure you want to quit?", this.parent.skin)).spaceBottom(10.0f);
        t.row();
        TextButton quit = new TextButton("Quit", this.parent.skin);
        quit.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                QuitConfirmationScreen.this.parent.setScreen(QuitConfirmationScreen.this.parent.end);
            }
        });
        t.add(quit).top().size(100.0f, 25.0f).spaceBottom(space);
        t.row();
        TextButton SaveBtn = new TextButton("Save", this.parent.skin);
        SaveBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                QuitConfirmationScreen.this.showSaveMenu();
            }
        });
        t.add(SaveBtn).top().size(100.0f, 25.0f).spaceBottom(space);
        t.row();
        TextButton RestartBtn = new TextButton("Restart", this.parent.skin);
        RestartBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SaveObject.readXML("restart.xml");
                DifficultyManager.SelectEasy();
                QuitConfirmationScreen.this.parent.setScreen(QuitConfirmationScreen.this.parent.game);
                GameManager.getPlayer().updateHealth();
            }
        });
        t.add(RestartBtn).top().size(100.0f, 25.0f).spaceBottom(space);
        t.row();
        TextButton back = new TextButton("Return", this.parent.skin);
        back.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                QuitConfirmationScreen.this.parent.setScreen(QuitConfirmationScreen.this.parent.game);
            }
        });
        t.add(back).top().size(100.0f, 25.0f).spaceBottom(space);
        t.top();
        this.actors.add(t);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        Table t = (Table)this.actors.get(0);
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("shopBG.jpg")));
    }

    private void showSaveMenu() {
        if (System.getProperty("os.name").contains("Mac")) {
            SaveObject.writeXMl("mac_save.xml");
        } else {
            JFileChooser fileChooser = new JFileChooser();
            int value = fileChooser.showSaveDialog(null);
            if (value == 0) {
                File selected = fileChooser.getSelectedFile();
                SaveObject.writeXMl(selected.getAbsolutePath());
                DifficultyManager.SelectEasy();
                this.parent.setScreen(this.parent.game);
                GameManager.getPlayer().updateHealth();
            }
        }
    }
}

