/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.mygdx.game.Managers.DifficultyManager;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.PirateGame;
import com.mygdx.game.UI.Page;
import com.mygdx.utils.Constants;
import com.mygdx.utils.SaveObject;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JFileChooser;

public class MenuScreen
extends Page {
    public MenuScreen(PirateGame parent) {
        super(parent);
    }

    @Override
    protected void CreateActors() {
        Table t = new Table();
        t.setFillParent(true);
        float space = (float)Constants.VIEWPORT_HEIGHT * 0.1f;
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("newmenuBG.jpg")));
        Label l = new Label((CharSequence)"Pirates the movie the game", this.parent.skin);
        l.setFontScale(2.0f);
        t.add(l).top().spaceBottom(space * 0.5f);
        t.row();
        TextButton play = new TextButton("Play", this.parent.skin);
        t.add(play).top().size(100.0f, 25.0f);
        t.row();
        final SelectBox<String> selectBox = new SelectBox<String>(this.parent.skin);
        selectBox.setItems("Select Difficulty", "Easy", "Normal", "Hard");
        t.add(selectBox).top().size(100.0f, 25.0f).spaceBottom(space);
        t.row();
        play.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                switch ((String)selectBox.getSelected()) {
                    case "Select Difficulty": {
                        return;
                    }
                    case "Easy": {
                        DifficultyManager.SelectEasy();
                        break;
                    }
                    case "Normal": {
                        DifficultyManager.SelectNormal();
                        break;
                    }
                    case "Hard": {
                        DifficultyManager.SelectHard();
                    }
                }
                MenuScreen.this.parent.setScreen(MenuScreen.this.parent.game);
                GameManager.getPlayer().updateHealth();
            }
        });
        TextButton load = new TextButton("Load", this.parent.skin);
        load.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                try {
                    MenuScreen.this.showLoadMenu();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        t.add(load).top().size(100.0f, 25.0f).spaceBottom(space);
        t.row();
        TextButton quit = new TextButton("Quit", this.parent.skin);
        quit.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
                System.exit(0);
            }
        });
        t.add(quit).size(100.0f, 25.0f).top().spaceBottom(space);
        t.top();
        this.actors.add(t);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        Table t = (Table)this.actors.get(0);
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("newmenuBG.jpg")));
    }

    private void showLoadMenu() throws FileNotFoundException {
        if (System.getProperty("os.name").contains("Mac")) {
            File f = new File("mac_save.xml");
            if (!f.exists()) {
                throw new FileNotFoundException();
            }
            SaveObject.readXML("SAVED_GAME.xml");
            DifficultyManager.SelectEasy();
            this.parent.setScreen(this.parent.game);
            GameManager.getPlayer().updateHealth();
        } else {
            JFileChooser fileChooser = new JFileChooser();
            int value = fileChooser.showOpenDialog(null);
            if (value == 0) {
                File selected = fileChooser.getSelectedFile();
                SaveObject.readXML(selected.getAbsolutePath());
                DifficultyManager.SelectEasy();
                this.parent.setScreen(this.parent.game);
                GameManager.getPlayer().updateHealth();
            }
        }
    }
}

