/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.utils.ScreenUtils;
import com.mygdx.game.Components.ComponentEvent;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Managers.EntityManager;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.PhysicsManager;
import com.mygdx.game.Managers.QuestManager;
import com.mygdx.game.Managers.RenderingManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.PirateGame;
import com.mygdx.game.Quests.Quest;
import com.mygdx.game.UI.Page;
import com.mygdx.game.UI.PowerupScreen;
import com.mygdx.utils.Constants;
import java.util.ArrayList;
import java.util.Random;

public class GameScreen
extends Page {
    public static Label healthLabel;
    public static Label dosh;
    public static Label ammo;
    public static Label points;
    public static Label questName;
    public static Label questDesc;
    private Label power_up_name1;
    private Label power_up_time1;
    private Label power_up_name2;
    private Label power_up_time2;
    private Label warn1;
    private Label warn2;
    public static float[] powers;
    public static int[] durations;
    public static float warn1_time;
    public static float warn2_time;
    public static int timer;
    public static int num_powers;
    public static int message1;
    public static int message2;
    private Texture texture;
    private float interval;
    private Random r = new Random();
    private float accumulator;

    public GameScreen(PirateGame parent, int id_map) {
        super(parent);
        Constants.INIT_CONSTANTS();
        PhysicsManager.Initialize(false);
        GameManager.SpawnGame(id_map);
        EntityManager.raiseEvents(ComponentEvent.Awake, ComponentEvent.Start);
        Window questWindow = new Window("Current Quest", parent.skin);
        Quest q = QuestManager.currentQuest();
        Table t = new Table();
        questName = new Label((CharSequence)"NAME", parent.skin);
        t.add(questName);
        t.row();
        questDesc = new Label((CharSequence)"DESCRIPTION", parent.skin);
        if (q != null) {
            questName.setText(q.getName());
            questDesc.setText(q.getDescription());
        }
        t.add(questDesc).left();
        questWindow.add(t);
        this.actors.add(questWindow);
        Table t1 = new Table();
        t1.top().right();
        t1.setFillParent(true);
        this.actors.add(t1);
        Window tutWindow = new Window("Controls", parent.skin);
        Table table = new Table();
        tutWindow.add(table);
        t1.add(tutWindow);
        table.add(new Label((CharSequence)"Move with", parent.skin)).top().left();
        table.add(new Image(parent.skin, "key-w"));
        table.add(new Image(parent.skin, "key-s"));
        table.add(new Image(parent.skin, "key-a"));
        table.add(new Image(parent.skin, "key-d"));
        table.row();
        table.add(new Label((CharSequence)"Shoot in direction of mouse", parent.skin)).left();
        table.add(new Image(parent.skin, "mouse"));
        table.row();
        table.add(new Label((CharSequence)"Shoot in direction of ship", parent.skin)).left();
        table.add(new Image(parent.skin, "space"));
        table.row();
        table.add(new Label((CharSequence)"Quit", parent.skin)).left();
        table.add(new Image(parent.skin, "key-esc"));
        table.row();
        table.add(new Label((CharSequence)"Shop", parent.skin)).left();
        table.add(new Image(parent.skin, "key-e"));
        powers = new float[6];
        durations = new int[]{20, 30, 25, 20, 15, 5};
        num_powers = 0;
        message1 = -1;
        message2 = -1;
        warn1_time = 0.0f;
        warn2_time = 0.0f;
        this.interval = 0.0f;
        GameManager.ships.get(1).setHealth(0);
        GameManager.ships.get(2).setHealth(0);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(Constants.BACKGROUND_COLOUR.x, Constants.BACKGROUND_COLOUR.y, Constants.BACKGROUND_COLOUR.z, 1.0f);
        EntityManager.raiseEvents(ComponentEvent.Update, ComponentEvent.Render);
        this.accumulator += EntityManager.getDeltaTime();
        while (this.accumulator >= Constants.PHYSICS_TIME_STEP) {
            PhysicsManager.update();
            this.accumulator -= Constants.PHYSICS_TIME_STEP;
        }
        if (Gdx.input.isKeyJustPressed(111)) {
            this.parent.setScreen(this.parent.quitConfirm);
        }
        if (Gdx.input.isKeyJustPressed(33)) {
            this.parent.setScreen(this.parent.shop);
        }
        GameManager.update();
        super.render(0.0f);
    }

    @Override
    public void dispose() {
        super.dispose();
        ResourceManager.cleanUp();
        EntityManager.cleanUp();
        RenderingManager.cleanUp();
        PhysicsManager.cleanUp();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        OrthographicCamera cam = RenderingManager.getCamera();
        cam.viewportWidth = (float)width / 1.75f;
        cam.viewportHeight = (float)height / 1.75f;
        cam.update();
    }

    @Override
    protected void update() {
        super.update();
        Player p = GameManager.getPlayer();
        boolean reward_powerUp = p.getReward_powerUp();
        if (reward_powerUp) {
            this.rewardPowerUp();
            p.setReward_powerUp(false);
        }
        this.powerUp();
        if (timer == 60) {
            timer = 0;
            p.getComponent(Pirate.class).addPoints(1);
        } else {
            ++timer;
        }
        healthLabel.setText(String.valueOf(p.getHealth()));
        dosh.setText(String.valueOf(p.getPlunder()));
        ammo.setText(String.valueOf(p.getAmmo()));
        points.setText(String.valueOf(p.getComponent(Pirate.class).getPoints()));
        if (!QuestManager.anyQuests()) {
            this.parent.end.win();
            this.parent.setScreen(this.parent.end);
        } else if (!p.isAlive()) {
            this.parent.setScreen(this.parent.end);
        } else {
            Quest q = QuestManager.currentQuest();
            questName.setText(q.getName());
            questDesc.setText(q.getDescription());
        }
    }

    @Override
    protected void CreateActors() {
        Table table = new Table();
        table.setFillParent(true);
        this.actors.add(table);
        table.add(new Image(this.parent.skin.getDrawable("heart"))).top().left().size(1.25f * Constants.TILE_SIZE);
        healthLabel = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(healthLabel).top().left().size(50.0f);
        table.row();
        table.setDebug(false);
        table.add(new Image(this.parent.skin.getDrawable("coin"))).top().left().size(1.25f * Constants.TILE_SIZE);
        dosh = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(dosh).top().left().size(50.0f);
        table.row();
        table.add(new Image(ResourceManager.getTexture("points.png"))).top().left().size(1.25f * Constants.TILE_SIZE);
        points = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(points).top().left().size(50.0f);
        table.row();
        table.add(new Image(this.parent.skin.getDrawable("ball"))).top().left().size(1.25f * Constants.TILE_SIZE);
        ammo = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(ammo).top().left().size(50.0f);
        table.top().left();
        Table table_message = new Table();
        table_message.setFillParent(true);
        this.actors.add(table_message);
        this.power_up_name1 = new Label((CharSequence)"", this.parent.skin);
        this.power_up_time1 = new Label((CharSequence)"", this.parent.skin);
        this.power_up_name2 = new Label((CharSequence)"", this.parent.skin);
        this.power_up_time2 = new Label((CharSequence)"", this.parent.skin);
        this.warn1 = new Label((CharSequence)"", this.parent.skin);
        this.warn2 = new Label((CharSequence)"", this.parent.skin);
        table_message.add(this.warn2).bottom().right().size(60.0f);
        table_message.row();
        table_message.add(this.warn1).bottom().right().size(60.0f);
        table_message.row();
        table_message.add(this.power_up_name2).bottom().right().size(60.0f);
        table_message.row();
        table_message.add(this.power_up_time2).bottom().right().size(60.0f);
        table_message.row();
        table_message.add(this.power_up_name1).bottom().right().size(60.0f);
        table_message.row();
        table_message.add(this.power_up_time1).bottom().right().size(60.0f);
        table_message.row();
        table_message.bottom();
        this.generatePowerUpTable();
    }

    private void send_warn(int type) {
        if (type == 1) {
            warn1_time = 5.0f;
            this.warn1.setText("*You cannot have 2 identical power-ups at the same time*");
        } else {
            warn2_time = 5.0f;
            this.warn2.setText("*You can only have maximum 2 power-ups at the same time *");
        }
    }

    private void rewardPowerUp() {
        ArrayList<Ship> ships = GameManager.getShips();
        int j = this.r.nextInt(5);
        switch (j) {
            case 0: {
                if (PowerupScreen.isImortal && num_powers < 2) {
                    if (message1 == -1) {
                        this.power_up_name1.setText("Power Up - Temporary Immortality");
                        message1 = 0;
                    } else {
                        this.power_up_name2.setText("Power Up - Temporary Immortality");
                        message2 = 0;
                    }
                    ships.get(0).tempImmortality(true);
                    GameScreen.powers[0] = durations[0];
                    ++num_powers;
                    this.interval = 0.0f;
                    break;
                }
                if (powers[0] > 0.0f && num_powers < 2) {
                    this.send_warn(1);
                    break;
                }
                if (num_powers != 2) break;
                this.send_warn(2);
                break;
            }
            case 1: {
                if (PowerupScreen.isIncreasedDamage && num_powers < 2) {
                    if (message1 == -1) {
                        this.power_up_name1.setText("Power Up - Bigger Damage");
                        message1 = 1;
                    } else {
                        this.power_up_name2.setText("Power Up - Bigger Damage");
                        message2 = 1;
                    }
                    ships.get(0).biggerDamage(true);
                    GameScreen.powers[1] = durations[1];
                    ++num_powers;
                    break;
                }
                if (powers[1] > 0.0f && num_powers < 2) {
                    this.send_warn(1);
                    break;
                }
                if (num_powers != 2) break;
                this.send_warn(2);
                break;
            }
            case 2: {
                if (PowerupScreen.isMultiDamage && num_powers < 2) {
                    if (message1 == -1) {
                        this.power_up_name1.setText("Power Up - Shoot All 8 Directions");
                        message1 = 2;
                    } else {
                        this.power_up_name2.setText("Power Up - Shoot All 8 Directions");
                        message2 = 2;
                    }
                    ships.get(0).shoot8Directions(true);
                    GameScreen.powers[2] = durations[2];
                    ++num_powers;
                    break;
                }
                if (powers[2] > 0.0f && num_powers < 2) {
                    this.send_warn(1);
                    break;
                }
                if (num_powers != 2) break;
                this.send_warn(2);
                break;
            }
            case 3: {
                if (PowerupScreen.isUnlimitedAmmo && num_powers < 2) {
                    if (message1 == -1) {
                        this.power_up_name1.setText("Power Up - Unlimited Ammo");
                        message1 = 3;
                    } else {
                        this.power_up_name2.setText("Power Up - Unlimited Ammo");
                        message2 = 3;
                    }
                    ships.get(0).unlimitedAmmo(true);
                    GameScreen.powers[3] = durations[3];
                    ++num_powers;
                    break;
                }
                if (powers[3] > 0.0f && num_powers < 2) {
                    this.send_warn(1);
                    break;
                }
                if (num_powers != 2) break;
                this.send_warn(2);
                break;
            }
            case 4: {
                if (PowerupScreen.isFreezeEnemy && num_powers < 2) {
                    if (message1 == -1) {
                        this.power_up_name1.setText("Power Up - Freeze Enemies");
                        message1 = 4;
                    } else {
                        this.power_up_name2.setText("Power Up - Freeze Enemies");
                        message2 = 4;
                    }
                    for (int i = 1; i < ships.size(); ++i) {
                        ships.get(i).setFreeze(true);
                    }
                    GameScreen.powers[4] = durations[4];
                    ++num_powers;
                    break;
                }
                if (powers[4] > 0.0f && num_powers < 2) {
                    this.send_warn(1);
                    break;
                }
                if (num_powers != 2) break;
                this.send_warn(2);
                break;
            }
        }
    }

    private void generatePowerUpTable() {
        Table t2 = new Table();
        t2.bottom().right();
        t2.setFillParent(true);
        this.actors.add(t2);
        Window powerWindow = new Window("Powerups", this.parent.skin);
        Table powerTable = new Table();
        powerWindow.add(powerTable);
        t2.row();
        t2.add(powerWindow).right();
        powerTable.add(new Image(ResourceManager.getTexture("powerups/powerup1.png")));
        powerTable.add(new Image(ResourceManager.getTexture("powerups/powerup2.png")));
        powerTable.add(new Image(ResourceManager.getTexture("powerups/powerup3.png")));
        powerTable.add(new Image(ResourceManager.getTexture("powerups/powerup4.png")));
        powerTable.add(new Image(ResourceManager.getTexture("powerups/powerup5.png")));
    }

    private void powerUp() {
        int i;
        ArrayList<Ship> ships = GameManager.getShips();
        float threshold = 0.1f;
        this.interval += Gdx.graphics.getDeltaTime();
        if (Gdx.input.isKeyPressed(8)) {
            if (PowerupScreen.isImortal && num_powers < 2) {
                if (message1 == -1) {
                    this.power_up_name1.setText("Power Up - Temporary Immortality");
                    message1 = 0;
                } else {
                    this.power_up_name2.setText("Power Up - Temporary Immortality");
                    message2 = 0;
                }
                ships.get(0).tempImmortality(true);
                PowerupScreen.isImortal = false;
                GameScreen.powers[0] = durations[0];
                ++num_powers;
                this.interval = 0.0f;
            } else if (powers[0] > 0.0f && num_powers < 2) {
                if (this.interval > threshold) {
                    this.send_warn(1);
                    this.interval = 0.0f;
                }
            } else if (num_powers == 2 && this.interval > threshold) {
                this.send_warn(2);
                this.interval = 0.0f;
            }
        }
        if (Gdx.input.isKeyPressed(9)) {
            if (PowerupScreen.isIncreasedDamage && num_powers < 2) {
                if (message1 == -1) {
                    this.power_up_name1.setText("Power Up - Bigger Damage");
                    message1 = 1;
                } else {
                    this.power_up_name2.setText("Power Up - Bigger Damage");
                    message2 = 1;
                }
                ships.get(0).biggerDamage(true);
                PowerupScreen.isIncreasedDamage = false;
                GameScreen.powers[1] = durations[1];
                ++num_powers;
                this.interval = 0.0f;
            } else if (powers[1] > 0.0f && num_powers < 2) {
                if (this.interval > threshold) {
                    this.send_warn(1);
                    this.interval = 0.0f;
                }
            } else if (num_powers == 2 && this.interval > threshold) {
                this.send_warn(2);
                this.interval = 0.0f;
            }
        }
        if (Gdx.input.isKeyPressed(10)) {
            if (PowerupScreen.isMultiDamage && num_powers < 2) {
                if (message1 == -1) {
                    this.power_up_name1.setText("Power Up - Shoot All 8 Directions");
                    message1 = 2;
                } else {
                    this.power_up_name2.setText("Power Up - Shoot All 8 Directions");
                    message2 = 2;
                }
                ships.get(0).shoot8Directions(true);
                PowerupScreen.isMultiDamage = false;
                GameScreen.powers[2] = durations[2];
                ++num_powers;
                this.interval = 0.0f;
            } else if (powers[2] > 0.0f && num_powers < 2) {
                if (this.interval > threshold) {
                    this.send_warn(1);
                    this.interval = 0.0f;
                }
            } else if (num_powers == 2 && this.interval > threshold) {
                this.send_warn(2);
                this.interval = 0.0f;
            }
        }
        if (Gdx.input.isKeyPressed(11)) {
            if (PowerupScreen.isUnlimitedAmmo && num_powers < 2) {
                if (message1 == -1) {
                    this.power_up_name1.setText("Power Up - Unlimited Ammo");
                    message1 = 3;
                } else {
                    this.power_up_name2.setText("Power Up - Unlimited Ammo");
                    message2 = 3;
                }
                ships.get(0).unlimitedAmmo(true);
                PowerupScreen.isUnlimitedAmmo = false;
                GameScreen.powers[3] = durations[3];
                ++num_powers;
                this.interval = 0.0f;
            } else if (powers[3] > 0.0f && num_powers < 2) {
                if (this.interval > threshold) {
                    this.send_warn(1);
                    this.interval = 0.0f;
                }
            } else if (num_powers == 2 && this.interval > threshold) {
                this.send_warn(2);
                this.interval = 0.0f;
            }
        }
        if (Gdx.input.isKeyPressed(12)) {
            if (PowerupScreen.isFreezeEnemy && num_powers < 2) {
                if (message1 == -1) {
                    this.power_up_name1.setText("Power Up - Freeze Enemies");
                    message1 = 4;
                } else {
                    this.power_up_name2.setText("Power Up - Freeze Enemies");
                    message2 = 4;
                }
                for (i = 1; i < ships.size(); ++i) {
                    ships.get(i).setFreeze(true);
                }
                PowerupScreen.isFreezeEnemy = false;
                GameScreen.powers[4] = durations[4];
                ++num_powers;
                this.interval = 0.0f;
            } else if (powers[4] > 0.0f && num_powers < 2) {
                if (this.interval > threshold) {
                    this.send_warn(1);
                    this.interval = 0.0f;
                }
            } else if (num_powers == 2 && this.interval > threshold) {
                this.send_warn(2);
                this.interval = 0.0f;
            }
        }
        block8: for (i = 0; i < 6; ++i) {
            if (powers[i] >= 5.0f) {
                int n = i;
                powers[n] = powers[n] - Gdx.graphics.getDeltaTime();
                continue;
            }
            if (powers[i] > 0.0f && powers[i] < 5.0f) {
                int n = i;
                powers[n] = powers[n] - Gdx.graphics.getDeltaTime();
                switch (i) {
                    case 0: {
                        ships.get(0).tempImmortality(false);
                        break;
                    }
                    case 1: {
                        ships.get(0).biggerDamage(false);
                        break;
                    }
                    case 2: {
                        ships.get(0).shoot8Directions(false);
                        break;
                    }
                    case 3: {
                        ships.get(0).unlimitedAmmo(false);
                        break;
                    }
                    case 4: {
                        for (int j = 1; j < ships.size(); ++j) {
                            ships.get(j).setFreeze(false);
                        }
                        continue block8;
                    }
                }
                continue;
            }
            if (!(powers[i] < 0.0f)) continue;
            GameScreen.powers[i] = 0.0f;
            --num_powers;
        }
        if (message1 != -1) {
            if (powers[message1] > 5.0f) {
                this.power_up_time1.setText(String.valueOf((int)powers[message1] - 5));
            } else if (powers[message1] < 0.0f) {
                this.power_up_name1.setText("");
                this.power_up_time1.setText("");
                message1 = -1;
            } else {
                this.power_up_time1.setText("TIME UP");
                if (message1 == 5) {
                    this.power_up_time1.setText("ACTIVATED");
                }
            }
        }
        if (message2 != -1) {
            if (powers[message2] > 5.0f) {
                this.power_up_time2.setText(String.valueOf((int)powers[message2] - 5));
            } else if (powers[message2] < 0.0f) {
                this.power_up_name2.setText("");
                this.power_up_time2.setText("");
                message2 = -1;
            } else {
                this.power_up_time2.setText("TIME UP");
                if (message2 == 5) {
                    this.power_up_time2.setText("ACTIVATED");
                }
            }
        }
        if (warn1_time > 0.0f) {
            warn1_time -= Gdx.graphics.getDeltaTime();
        } else if (warn1_time < 0.0f) {
            warn1_time = 0.0f;
            this.warn1.setText("");
        }
        if (warn2_time > 0.0f) {
            warn2_time -= Gdx.graphics.getDeltaTime();
        } else if (warn2_time < 0.0f) {
            warn2_time = 0.0f;
            this.warn2.setText("");
        }
    }
}

