/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Managers.DifficultyManager;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.QuestManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.PirateGame;
import com.mygdx.game.UI.Page;
import com.mygdx.utils.Constants;
import com.mygdx.utils.SaveObject;

public class EndScreen
extends Page {
    Label wonText;
    Label playerStats;
    Integer questsNeeded;
    Integer pointsNeeded;

    public EndScreen(PirateGame game) {
        super(game);
    }

    public void win() {
        this.wonText.setText("Congrats You Have Won");
    }

    @Override
    protected void CreateActors() {
        Table t = new Table();
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("menuBG.jpg")));
        float space = (float)Constants.VIEWPORT_HEIGHT * 0.25f;
        t.setFillParent(true);
        this.actors.add(t);
        this.wonText = new Label((CharSequence)"You have lost", this.parent.skin);
        this.wonText.setFontScale(2.0f);
        t.top();
        t.add(this.wonText).top().spaceBottom(space);
        t.row();
        this.playerStats = new Label((CharSequence)"Player Stats:\n", this.parent.skin);
        t.add(this.playerStats).spaceBottom(space);
        t.row();
        TextButton b = new TextButton("Exit", this.parent.skin);
        b.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
                System.exit(0);
            }
        });
        t.add(b).spaceBottom(5.0f);
        t.row();
        TextButton RestartBtn = new TextButton("Restart", this.parent.skin);
        RestartBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.files.internal("restart.xml").reader();
                String path = Gdx.files.internal("restart.xml").file().getPath();
                SaveObject.readXML("restart.xml");
                DifficultyManager.SelectEasy();
                EndScreen.this.parent.setScreen(EndScreen.this.parent.game);
                GameManager.getPlayer().updateHealth();
            }
        });
        t.add(RestartBtn).top().size(100.0f, 25.0f).spaceBottom(space);
        t.row();
    }

    @Override
    protected void update() {
        super.update();
        if (Gdx.input.isKeyJustPressed(111)) {
            Gdx.app.exit();
            System.exit(0);
        }
    }

    @Override
    public void show() {
        super.show();
        if (this.WinCheck()) {
            this.win();
        }
        Player p = GameManager.getPlayer();
        String stats = String.format("Health: %s\nAmmo: %s\nPlunder: %s\nPoints: %s/%s\nQuests Completed: %s/%s", p.getHealth(), p.getAmmo(), p.getPlunder(), p.getComponent(Pirate.class).getPoints(), this.pointsNeeded, QuestManager.numCompleted, this.questsNeeded);
        this.playerStats.setText(stats);
    }

    private boolean WinCheck() {
        Boolean result = false;
        this.questsNeeded = 0;
        this.pointsNeeded = 0;
        switch (DifficultyManager.getDifficulty()) {
            case "e": {
                this.questsNeeded = 1;
                this.pointsNeeded = 100;
                break;
            }
            case "n": {
                this.questsNeeded = 3;
                this.pointsNeeded = 500;
                break;
            }
            case "h": {
                this.questsNeeded = 5;
                this.pointsNeeded = 1000;
            }
        }
        if (QuestManager.numCompleted >= this.questsNeeded && GameManager.getPlayer().getComponent(Pirate.class).getPoints() > this.pointsNeeded) {
            result = true;
        }
        return result;
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        Table t = (Table)this.actors.get(0);
        t.setBackground(new TextureRegionDrawable(ResourceManager.getTexture("menuBG.jpg")));
    }
}

