/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import java.util.ArrayList;
import java.util.HashMap;

public final class ResourceManager {
    private static boolean initialized = false;
    private static boolean loaded;
    private static AssetManager manager;
    private static ArrayList<String> ids;
    private static ArrayList<TiledMap> tileMaps;
    private static HashMap<String, FreeTypeFontGenerator> fontGenerators;
    private static HashMap<String, BitmapFont> fonts;

    public static void Initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        manager = new AssetManager();
        loaded = false;
        ids = new ArrayList();
        tileMaps = new ArrayList();
        fontGenerators = new HashMap();
        fonts = new HashMap();
    }

    public static int addTexture(String fPath) {
        ResourceManager.tryInit();
        ResourceManager.checkAdd();
        manager.load(fPath, Texture.class);
        ids.add(fPath);
        return ids.size();
    }

    public static int addTextureAtlas(String fPath) {
        ResourceManager.tryInit();
        ResourceManager.checkAdd();
        manager.load(fPath, TextureAtlas.class);
        ids.add(fPath);
        return ids.size();
    }

    public static int addTileMap(String fPath) {
        ResourceManager.tryInit();
        ResourceManager.checkAdd();
        TiledMap map = new TmxMapLoader().load(fPath);
        tileMaps.add(map);
        ids.add("|TM|" + tileMaps.size() + fPath);
        return ids.size();
    }

    public static int addFontGenerator(String fontPath) {
        ResourceManager.tryInit();
        ResourceManager.checkAdd();
        if (fontGenerators.containsKey(fontPath)) {
            return -1;
        }
        fontGenerators.put(fontPath, new FreeTypeFontGenerator(Gdx.files.internal(fontPath)));
        ids.add("|FG|" + fontPath);
        return ids.size();
    }

    public static int createFont(int font_generator_id, int fontSize) {
        ResourceManager.tryInit();
        String fontName = ids.get(font_generator_id - 1);
        fontName = fontName.substring(4);
        FreeTypeFontGenerator generator = fontGenerators.get(fontName);
        FreeTypeFontGenerator.FreeTypeFontParameter params = new FreeTypeFontGenerator.FreeTypeFontParameter();
        params.size = fontSize;
        params.color.r = 0.0f;
        params.color.g = 0.0f;
        params.color.b = 0.0f;
        BitmapFont font = generator.generateFont(params);
        ids.add("|FT|" + fontSize + fontName);
        fonts.put(fontSize + fontName, font);
        return ids.size();
    }

    public static int createFont(String fontName, int fontSize) {
        ResourceManager.tryInit();
        if (!fontGenerators.containsKey(fontName)) {
            return -1;
        }
        FreeTypeFontGenerator generator = fontGenerators.get(fontName);
        FreeTypeFontGenerator.FreeTypeFontParameter params = new FreeTypeFontGenerator.FreeTypeFontParameter();
        params.size = fontSize;
        params.color.r = 1.0f;
        params.color.g = 1.0f;
        params.color.b = 1.0f;
        BitmapFont font = generator.generateFont(params);
        ids.add("|FT|" + fontSize + fontName);
        fonts.put(fontSize + fontName, font);
        return ids.size();
    }

    public static void loadAssets() {
        ResourceManager.tryInit();
        loaded = true;
        manager.finishLoading();
    }

    public static Texture getTexture(String fPath) {
        ResourceManager.tryInit();
        return (Texture)manager.get(fPath);
    }

    public static TextureAtlas getTextureAtlas(String fPath) {
        ResourceManager.tryInit();
        TextureAtlas t = (TextureAtlas)manager.get(fPath);
        for (Texture t0 : t.getTextures()) {
            t0.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        }
        return (TextureAtlas)manager.get(fPath);
    }

    public static TiledMap getTileMap(String fPath) {
        ResourceManager.tryInit();
        int id = -1;
        for (String fName : ids) {
            String slice;
            if (fName.length() < 4 || !(slice = fName.substring(0, 4)).equals("|TM|") || !fName.contains(fPath)) continue;
            id = Character.getNumericValue(fName.charAt(4));
            break;
        }
        if (id < 0) {
            return null;
        }
        return tileMaps.get(id - 1);
    }

    public static Texture getTexture(int id) {
        ResourceManager.tryInit();
        String fPath = ids.get(id - 1);
        return (Texture)manager.get(fPath);
    }

    public static TextureAtlas getTextureAtlas(int id) {
        ResourceManager.tryInit();
        String fPath = ids.get(id - 1);
        return ResourceManager.getTextureAtlas(fPath);
    }

    public static Sprite getSprite(int atlas_id, String name) {
        TextureAtlas t = ResourceManager.getTextureAtlas(atlas_id);
        return ResourceManager.getTextureAtlas(atlas_id).createSprite(name);
    }

    public static Sprite getSprite(String img) {
        Texture texture = new Texture(img);
        return new Sprite(texture);
    }

    public static TiledMap getTileMap(int id) {
        ResourceManager.tryInit();
        String fPath = ids.get(id - 1);
        if (fPath.length() < 4) {
            return null;
        }
        String slice = fPath.substring(0, 4);
        if (!slice.equals("|TM|")) {
            return null;
        }
        int id_ = Character.getNumericValue(fPath.charAt(4));
        return tileMaps.get(id_ - 1);
    }

    public static int getId(String name) {
        return ids.indexOf(name) + 1;
    }

    public static BitmapFont getFont(int font_id) {
        String fontName = ids.get(font_id - 1);
        fontName = fontName.substring(4);
        return fonts.get(fontName);
    }

    public static BitmapFont getFont(String fontName) {
        return fonts.get(fontName);
    }

    public static void cleanUp() {
        ResourceManager.tryInit();
        manager.dispose();
        for (TiledMap map : tileMaps) {
            map.dispose();
        }
        for (BitmapFont font : fonts.values()) {
            font.dispose();
        }
        for (FreeTypeFontGenerator generator : fontGenerators.values()) {
            generator.dispose();
        }
    }

    private static void checkAdd() {
        if (loaded) {
            throw new RuntimeException("Can't load assets at this stage");
        }
    }

    private static void tryInit() {
        if (!initialized) {
            ResourceManager.Initialize();
        }
    }
}

