/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.mygdx.game.AI.TileMapGraph;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.CannonBall;
import com.mygdx.game.Entitys.CannonBallCollege;
import com.mygdx.game.Entitys.College;
import com.mygdx.game.Entitys.Monster;
import com.mygdx.game.Entitys.NPCShip;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Entitys.Weather;
import com.mygdx.game.Entitys.WorldMap;
import com.mygdx.game.Faction;
import com.mygdx.game.Managers.QuestManager;
import com.mygdx.utils.QueueFIFO;
import com.mygdx.utils.Utilities;
import java.util.ArrayList;

public final class GameManager {
    private static boolean initialized = false;
    private static ArrayList<Faction> factions;
    public static ArrayList<Ship> ships;
    public static ArrayList<College> colleges;
    public static ArrayList<Weather> weathers;
    public static ArrayList<Monster> monsters;
    private static final int cacheSize = 50;
    private static ArrayList<CannonBall> ballCache;
    private static ArrayList<CannonBallCollege> ballCache2;
    private static int currentElement;
    private static JsonValue settings;
    private static TileMapGraph mapGraph;

    public static void Initialize() {
        int i;
        initialized = true;
        currentElement = 0;
        settings = new JsonReader().parse(Gdx.files.internal("GameSettings.json"));
        factions = new ArrayList();
        ships = new ArrayList();
        ballCache = new ArrayList(50);
        ballCache2 = new ArrayList(50);
        colleges = new ArrayList();
        weathers = new ArrayList();
        monsters = new ArrayList();
        for (i = 0; i < 50; ++i) {
            ballCache.add(new CannonBall());
        }
        for (i = 0; i < 50; ++i) {
            ballCache2.add(new CannonBallCollege());
        }
        for (JsonValue v : settings.get("factions")) {
            String name = v.getString("name");
            String col = v.getString("colour");
            Vector2 pos = new Vector2(v.get("position").getFloat("x"), v.get("position").getFloat("y"));
            pos = Utilities.tilesToDistance(pos);
            Vector2 spawn = new Vector2(v.get("shipSpawn").getFloat("x"), v.get("shipSpawn").getFloat("y"));
            spawn = Utilities.tilesToDistance(spawn);
            factions.add(new Faction(name, col, pos, spawn, factions.size() + 1));
        }
    }

    public static void update() {
        QuestManager.checkCompleted();
    }

    public static Player getPlayer() {
        return (Player)ships.get(0);
    }

    public static ArrayList<Ship> getShips() {
        return ships;
    }

    public static void SpawnGame(int mapId) {
        GameManager.CreateWorldMap(mapId);
        GameManager.CreatePlayer();
        GameManager.CreateWeather();
        GameManager.CreateMonster();
        int cnt = settings.get("factionDefaults").getInt("shipCount");
        for (int i = 0; i < factions.size(); ++i) {
            GameManager.CreateCollege(i + 1);
            for (int j = 0; j < cnt && (i != 0 || j <= cnt - 2); ++j) {
                NPCShip s = GameManager.CreateNPCShip(i + 1);
                s.getComponent(Transform.class).setPosition(GameManager.getFaction(i + 1).getSpawnPos());
            }
        }
    }

    public static void CreatePlayer() {
        GameManager.tryInit();
        Player p = new Player();
        p.setFaction(1);
        ships.add(p);
    }

    public static void CreateMonster() {
        GameManager.tryInit();
        Monster m = new Monster();
        monsters.add(m);
    }

    public static Weather CreateWeather() {
        GameManager.tryInit();
        Weather e = new Weather();
        weathers.add(e);
        return e;
    }

    public static NPCShip CreateNPCShip(int factionId) {
        GameManager.tryInit();
        NPCShip e = new NPCShip();
        e.setFaction(factionId);
        ships.add(e);
        return e;
    }

    public static void addNPCMyShip() {
        NPCShip e = new NPCShip();
        e.setFaction(1);
        ships.add(e);
    }

    public static void CreateWorldMap(int mapId) {
        GameManager.tryInit();
        WorldMap map = new WorldMap(mapId);
        mapGraph = new TileMapGraph(map.getTileMap());
    }

    public static void CreateCollege(int factionId) {
        GameManager.tryInit();
        College c = new College(factionId);
        colleges.add(c);
    }

    private static void tryInit() {
        if (!initialized) {
            GameManager.Initialize();
        }
    }

    public static Faction getFaction(int factionId) {
        GameManager.tryInit();
        return factions.get(factionId - 1);
    }

    public static JsonValue getSettings() {
        GameManager.tryInit();
        return settings;
    }

    public static College getCollege(int factionId) {
        GameManager.tryInit();
        return colleges.get(factionId - 1);
    }

    public static void shoot(Ship p, Vector2 dir) {
        Vector2 pos = p.getComponent(Transform.class).getPosition().cpy();
        ballCache.get(currentElement++).fire(pos, dir, p);
        currentElement %= 50;
    }

    public static void shoot2(College c, Vector2 dir) {
        Vector2 pos = c.getComponent(Transform.class).getPosition().cpy();
        ballCache2.get(currentElement++).fire(pos, dir, c);
        currentElement %= 50;
    }

    public static QueueFIFO<Vector2> getPath(Vector2 loc, Vector2 dst) {
        return mapGraph.findOptimisedPath(loc, dst);
    }
}

