/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.Gdx;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentEvent;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Managers.RenderingManager;
import java.util.ArrayList;

public final class EntityManager {
    private static ArrayList<String> entityNames;
    private static ArrayList<Entity> entities;
    private static ArrayList<Component> components;
    private static boolean initialized;

    public static void Initialize() {
        entityNames = new ArrayList();
        entities = new ArrayList();
        components = new ArrayList();
        initialized = true;
    }

    public static void addComponent(Component c) {
        EntityManager.tryInit();
        components.add(c);
    }

    public static void addEntity(Entity e) {
        EntityManager.tryInit();
        entities.add(e);
        entityNames.add(e.getName());
    }

    public static Entity getEntity(String name) {
        return entities.get(entityNames.indexOf(name));
    }

    public static void changeName(String prev, String new_) {
        entityNames.set(entityNames.indexOf(prev), new_);
    }

    public static void raiseEvents(ComponentEvent ... comps) {
        EntityManager.tryInit();
        for (Entity e : entities) {
            e.raiseEvents(comps);
        }
        for (ComponentEvent c : comps) {
            if (c != ComponentEvent.Render) continue;
            RenderingManager.render();
            break;
        }
        for (Entity e : entities) {
            e.update();
        }
    }

    public static void cleanUp() {
        EntityManager.tryInit();
        for (Entity e : entities) {
            e.cleanUp();
        }
        for (Component c : components) {
            c.cleanUp();
        }
    }

    private static void tryInit() {
        if (!initialized) {
            EntityManager.Initialize();
        }
    }

    public static float getDeltaTime() {
        return Gdx.graphics.getDeltaTime();
    }

    public static int getFPS() {
        return Gdx.graphics.getFramesPerSecond();
    }

    static {
        initialized = false;
    }
}

