/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.game.Physics.PhysicsBodyType;

public class Weather
extends Entity
implements CollisionCallBack {
    private static int weatherCount = 0;
    RigidBody rb;
    int count = 0;

    public Weather() {
        super(4);
        this.setName("Storm (" + weatherCount++ + ")");
        Transform t = new Transform();
        t.setPosition(900.0f, 800.0f);
        Renderable r = new Renderable("whirlpool.png", RenderLayer.Transparent);
        this.rb = new RigidBody(PhysicsBodyType.Dynamic, r, t);
        this.rb.setCallback(this);
        this.addComponents(t, r, this.rb);
    }

    public void moveWeather() {
        Vector2 dir = this.getRandomDirection();
        this.rb.setVelocity(dir);
    }

    private Vector2 getRandomDirection() {
        float x = (float)Math.floor(Math.random() * 3.0) - 1.0f;
        float y = (float)Math.floor(Math.random() * 3.0) - 1.0f;
        Vector2 dir = new Vector2(x * 1000.0f, y * 1000.0f);
        return dir;
    }

    @Override
    public void update() {
        super.update();
        if (this.count == 50) {
            this.moveWeather();
            this.count = 0;
        }
        ++this.count;
    }

    @Override
    public void BeginContact(CollisionInfo info) {
        this.EnterTrigger(info);
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
        if (this instanceof Weather && !(info.a instanceof Weather) && info.a != null) {
            ((CollisionCallBack)((Object)info.a)).EnterTrigger(info);
        }
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
        if (this instanceof Weather && !(info.a instanceof Weather) && info.a != null) {
            ((CollisionCallBack)((Object)info.a)).ExitTrigger(info);
        }
    }
}

