/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ObjectMap;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.CannonBall;
import com.mygdx.game.Entitys.CannonBallCollege;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Entitys.Monster;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Entitys.Weather;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.game.Physics.PhysicsBodyType;
import com.mygdx.utils.Utilities;
import java.util.Objects;

public class Ship
extends Entity
implements CollisionCallBack {
    private static int shipCount = 0;
    public static ObjectMap<Vector2, String> shipDirections;
    private final Vector2 currentDir = new Vector2();
    private boolean isFreeze;

    public Ship() {
        super(4);
        this.setName("Ship (" + shipCount++ + ")");
        this.isFreeze = false;
        if (shipDirections == null) {
            shipDirections = new ObjectMap();
            shipDirections.put(new Vector2(0.0f, 1.0f), "-up");
            shipDirections.put(new Vector2(0.0f, -1.0f), "-down");
            shipDirections.put(new Vector2(1.0f, 0.0f), "-right");
            shipDirections.put(new Vector2(-1.0f, 0.0f), "-left");
            shipDirections.put(new Vector2(1.0f, 1.0f), "-ur");
            shipDirections.put(new Vector2(-1.0f, 1.0f), "-ul");
            shipDirections.put(new Vector2(1.0f, -1.0f), "-dr");
            shipDirections.put(new Vector2(-1.0f, -1.0f), "-dl");
        }
        Transform t = new Transform();
        t.setPosition(800.0f, 800.0f);
        Renderable r = Application.ApplicationType.HeadlessDesktop == Gdx.app.getType() ? new Renderable() : new Renderable(3, "white-up", RenderLayer.Transparent);
        RigidBody rb = new RigidBody(PhysicsBodyType.Dynamic, r, t);
        rb.setCallback(this);
        Pirate p = new Pirate();
        this.addComponents(t, r, rb, p);
    }

    public boolean isAlive() {
        return this.getComponent(Pirate.class).getHealth() > 0;
    }

    public static float getAttackRange() {
        return Utilities.tilesToDistance(GameManager.getSettings().get("starting").getFloat("attackRange_tiles"));
    }

    public void plunder(int money) {
        this.getComponent(Pirate.class).addPlunder(money);
    }

    public void setFaction(int factionId) {
        this.getComponent(Pirate.class).setFactionId(factionId);
        if (Application.ApplicationType.HeadlessDesktop != Gdx.app.getType()) {
            this.setShipDirection("-up");
        }
    }

    public void setFreeze(boolean state) {
        this.isFreeze = state;
    }

    public boolean getFreeze() {
        return this.isFreeze;
    }

    private String getShipDirection(Vector2 dir) {
        if (!this.currentDir.equals(dir) && shipDirections.containsKey(dir)) {
            this.currentDir.set(dir);
            return shipDirections.get(dir);
        }
        return "";
    }

    private String getColour() {
        return this.getComponent(Pirate.class).getFaction().getColour();
    }

    public void setShipDirection(Vector2 dir) {
        this.setShipDirection(this.getShipDirection(dir));
    }

    public void setShipDirection(String direction) {
        if (Objects.equals(direction, "")) {
            return;
        }
        Renderable r = this.getComponent(Renderable.class);
        Sprite s = ResourceManager.getSprite(3, this.getColour() + direction);
        try {
            r.setTexture(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHealth() {
        return this.getComponent(Pirate.class).getHealth();
    }

    public void setHealth(int overrideHealth) {
        this.getComponent(Pirate.class).setHealth(overrideHealth);
    }

    public int getPlunder() {
        return this.getComponent(Pirate.class).getPlunder();
    }

    public void shoot(Vector2 dir) {
        this.getComponent(Pirate.class).shoot(dir);
    }

    public void shoot() {
        this.getComponent(Pirate.class).shoot(this.currentDir);
    }

    public void tempImmortality(boolean state) {
        this.getComponent(Pirate.class).setImmortality(state);
    }

    public void unlimitedAmmo(boolean state) {
        this.getComponent(Pirate.class).setUnlimitedAmmo(state);
    }

    public void shoot8Directions(boolean state) {
        this.getComponent(Pirate.class).setShootEightDirections(state);
    }

    public void biggerDamage(boolean state) {
        this.getComponent(Pirate.class).setBiggerDamage(state);
    }

    public Vector2 getPosition() {
        return this.getComponent(Transform.class).getPosition().cpy();
    }

    public void setPosition(Float x, Float y) {
        this.getComponent(Transform.class).setPosition(x.floatValue(), y.floatValue());
    }

    @Override
    public void BeginContact(CollisionInfo info) {
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    public void ShipDeath() {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
        if (this instanceof Player && !(info.b instanceof Player) && !(info.b instanceof Weather) && !(info.b instanceof Monster)) {
            ((CollisionCallBack)((Object)info.b)).EnterTrigger(info);
        }
        if (info.a instanceof CannonBall) {
            CannonBall ball = (CannonBall)info.a;
            if (ball.getShooter() != this & ball.getShooter().getComponent(Pirate.class).getFaction() != this.getComponent(Pirate.class).getFaction()) {
                Pirate pirate = this.getComponent(Pirate.class);
                pirate.takeDamage(5.0f);
                ball.kill();
                System.out.print(this.getName());
                System.out.println(this.getHealth());
            }
            if (!this.isAlive()) {
                Ship shooter = ball.getShooter();
                shooter.plunder(50);
                shooter.getComponent(Pirate.class).addPoints(100);
            }
        } else if (info.a instanceof CannonBallCollege) {
            CannonBallCollege ball = (CannonBallCollege)info.a;
            Pirate pirate = this.getComponent(Pirate.class);
            pirate.takeDamage(15.0f);
            ball.kill();
            System.out.print(this.getName());
            System.out.println(this.getHealth());
        } else if (info.b instanceof Weather) {
            Weather weather = (Weather)info.b;
            Pirate pirate = this.getComponent(Pirate.class);
            pirate.takeDamage(10.0f);
            System.out.print(this.getName());
            System.out.println(this.getHealth());
            System.out.println(this.getHealth());
        } else if (info.b instanceof Monster) {
            Monster monster = (Monster)info.b;
            Pirate pirate = this.getComponent(Pirate.class);
            pirate.takeDamage(40.0f);
            System.out.print(this.getName());
            System.out.println(this.getHealth());
            System.out.println(this.getHealth());
        }
        if (!this.isAlive()) {
            this.ShipDeath();
        }
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
        if (this instanceof Player && !(info.b instanceof Player) && !(info.b instanceof Weather) && !(info.b instanceof Monster)) {
            ((CollisionCallBack)((Object)info.b)).ExitTrigger(info);
        }
    }
}

