/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.ai.fsm.DefaultStateMachine;
import com.badlogic.gdx.ai.fsm.StateMachine;
import com.badlogic.gdx.ai.steer.behaviors.Arrive;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.mygdx.game.AI.EnemyState;
import com.mygdx.game.Components.AINavigation;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.utils.QueueFIFO;
import com.mygdx.utils.Utilities;
import java.util.Objects;

public class NPCShip
extends Ship
implements CollisionCallBack {
    public StateMachine<NPCShip, EnemyState> stateMachine;
    private static JsonValue AISettings;
    private final QueueFIFO<Vector2> path = new QueueFIFO();
    private int timer;

    public NPCShip() {
        if (AISettings == null) {
            AISettings = GameManager.getSettings().get("AI");
        }
        this.stateMachine = new DefaultStateMachine<NPCShip, EnemyState>(this, EnemyState.WANDER);
        this.setName("NPC");
        AINavigation nav = new AINavigation();
        this.addComponent(nav);
        RigidBody rb = this.getComponent(RigidBody.class);
        JsonValue starting = GameManager.getSettings().get("starting");
        rb.addTrigger(Utilities.tilesToDistance(starting.getFloat("argoRange_tiles")), "agro");
        this.timer = 0;
    }

    private Ship getTarget() {
        return this.getComponent(Pirate.class).getTarget();
    }

    @Override
    public void update() {
        if (!this.isAlive()) {
            return;
        }
        if (this.getFreeze()) {
            this.stopMovement();
            return;
        }
        super.update();
        this.stateMachine.update();
        AINavigation nav = this.getComponent(AINavigation.class);
        if (this.stateMachine.isInState(EnemyState.ATTACK)) {
            if (this.timer == 100) {
                Vector2 target = new Vector2(-1.0f * (this.getPosition().x - GameManager.ships.get((int)0).getPosition().x), -1.0f * (this.getPosition().y - GameManager.ships.get((int)0).getPosition().y));
                GameManager.shoot(this, target);
                this.timer = 0;
            } else {
                ++this.timer;
            }
        }
    }

    public void goToTarget() {
    }

    public void followTarget() {
        if (this.getTarget() == null || this.getFreeze()) {
            this.stopMovement();
            return;
        }
        AINavigation nav = this.getComponent(AINavigation.class);
        Arrive<Vector2> arrives = new Arrive<Vector2>(nav, this.getTarget().getComponent(Transform.class)).setTimeToTarget(AISettings.getFloat("accelerationTime")).setArrivalTolerance(AISettings.getFloat("arrivalTolerance")).setDecelerationRadius(AISettings.getFloat("slowRadius"));
        nav.setBehavior(arrives);
    }

    public void stopMovement() {
        AINavigation nav = this.getComponent(AINavigation.class);
        nav.setBehavior(null);
        nav.stop();
    }

    public void wander() {
    }

    @Override
    public void BeginContact(CollisionInfo info) {
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
        super.EnterTrigger(info);
        if (!(info.a instanceof Ship)) {
            return;
        }
        Ship other = (Ship)info.a;
        if (Objects.equals(other.getComponent(Pirate.class).getFaction().getName(), this.getComponent(Pirate.class).getFaction().getName())) {
            return;
        }
        Pirate pirate = this.getComponent(Pirate.class);
        pirate.addTarget(other);
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
        if (!(info.a instanceof Ship)) {
            return;
        }
        Pirate pirate = this.getComponent(Pirate.class);
        Ship o = (Ship)info.a;
        for (Ship targ : pirate.getTargets()) {
            if (targ != o) continue;
            pirate.getTargets().remove(targ);
            break;
        }
    }

    @Override
    public void ShipDeath() {
        this.stopMovement();
        this.getComponent(Renderable.class).hide();
        RigidBody rb = this.getComponent(RigidBody.class);
        rb.removeFromPhysicsWorld();
    }
}

