/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ObjectMap;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.CannonBall;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.game.Physics.PhysicsBodyType;
import java.util.Objects;

public class Monster
extends Entity
implements CollisionCallBack {
    private static int monsterCount = 0;
    public static ObjectMap<Vector2, String> directions;
    private int health = 200;
    private final Vector2 currentDir = new Vector2();
    RigidBody rb;
    int count = 0;

    public Monster() {
        super(4);
        this.setName("Storm (" + monsterCount++ + ")");
        if (directions == null) {
            directions = new ObjectMap();
            directions.put(new Vector2(0.0f, -1.0f), "-up");
            directions.put(new Vector2(0.0f, 1.0f), "-down");
            directions.put(new Vector2(-1.0f, 0.0f), "-right");
            directions.put(new Vector2(1.0f, 0.0f), "-left");
            directions.put(new Vector2(-1.0f, -1.0f), "-up-right");
            directions.put(new Vector2(1.0f, -1.0f), "-up-left");
            directions.put(new Vector2(-1.0f, 1.0f), "-down-right");
            directions.put(new Vector2(1.0f, 1.0f), "-down-left");
        }
        Transform t = new Transform();
        t.setPosition(1500.0f, 1000.0f);
        Renderable r = new Renderable("monster-up.png", RenderLayer.Transparent);
        this.rb = new RigidBody(PhysicsBodyType.Dynamic, r, t);
        this.rb.setCallback(this);
        this.addComponents(t, r, this.rb);
    }

    private String getDirection(Vector2 dir) {
        if (!this.currentDir.equals(dir) && directions.containsKey(dir)) {
            this.currentDir.set(dir);
            return directions.get(dir);
        }
        return "";
    }

    public void setDirection(Vector2 dir) {
        this.setDirection(this.getDirection(dir));
    }

    public void setDirection(String direction) {
        if (Objects.equals(direction, "")) {
            return;
        }
        Renderable r = this.getComponent(Renderable.class);
        Sprite s = ResourceManager.getSprite("monster" + direction + ".png");
        try {
            r.setTexture(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector2 getPosition() {
        return this.getComponent(Transform.class).getPosition().cpy();
    }

    private void moveMonster(Vector2 dir) {
        this.rb.setVelocity(dir);
    }

    @Override
    public void update() {
        super.update();
        float x = this.getPosition().x - GameManager.ships.get((int)0).getPosition().x;
        float y = this.getPosition().y - GameManager.ships.get((int)0).getPosition().y;
        Vector2 dir = new Vector2(x / -3.0f, y / -3.0f);
        if (y == 0.0f && x == 0.0f) {
            this.setDirection(new Vector2(x, y));
        } else if (Math.abs(x) < Math.abs(y)) {
            this.setDirection(new Vector2(Math.round(x / Math.abs(y)), Math.round(y / Math.abs(y))));
        } else {
            this.setDirection(new Vector2(Math.round(x / Math.abs(x)), Math.round(y / Math.abs(x))));
        }
        if (this.count == 200) {
            this.moveMonster(dir);
            this.count = 0;
        }
        ++this.count;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int number) {
        this.health = number;
    }

    private void takeDamage(int amount) {
        this.health -= amount;
    }

    public boolean isAlive() {
        return this.getHealth() > 0;
    }

    public void MonsterDeath() {
        this.getComponent(Renderable.class).hide();
        RigidBody rb = this.getComponent(RigidBody.class);
        rb.removeFromPhysicsWorld();
    }

    @Override
    public void BeginContact(CollisionInfo info) {
        this.EnterTrigger(info);
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
        if (this instanceof Monster && !(info.a instanceof Monster) && info.a != null) {
            ((CollisionCallBack)((Object)info.a)).EnterTrigger(info);
        }
        if (info.a instanceof CannonBall) {
            CannonBall ball = (CannonBall)info.a;
            this.takeDamage(5);
            ball.kill();
            if (!this.isAlive()) {
                Ship shooter = ball.getShooter();
                shooter.plunder(200);
                shooter.getComponent(Pirate.class).addPoints(100);
                this.MonsterDeath();
            }
        }
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
        if (this instanceof Monster && !(info.a instanceof Monster) && info.a != null) {
            ((CollisionCallBack)((Object)info.a)).ExitTrigger(info);
        }
    }
}

