/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.Building;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Faction;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.utils.Utilities;
import java.util.ArrayList;

public class College
extends Entity {
    private static ArrayList<String> buildingNames;
    private final ArrayList<Building> buildings = new ArrayList();
    private int i;
    private Vector2 target;
    private boolean active;

    public College() {
        buildingNames = new ArrayList();
        buildingNames.add("big");
        buildingNames.add("small");
        buildingNames.add("clock");
        this.i = 0;
        Transform t = new Transform();
        Pirate p = new Pirate();
        this.addComponents(t, p);
        this.active = true;
    }

    public College(int factionId) {
        this();
        Faction f = GameManager.getFaction(factionId);
        Transform t = this.getComponent(Transform.class);
        t.setPosition(f.getPosition());
        Pirate p = this.getComponent(Pirate.class);
        p.setFactionId(factionId);
        this.spawn(f.getColour());
    }

    private void spawn(String colour) {
        JsonValue collegeSettings = GameManager.getSettings().get("college");
        float radius = collegeSettings.getFloat("spawnRadius");
        Vector2 origin = this.getComponent(Transform.class).getPosition();
        ArrayList<Vector2> posList = new ArrayList<Vector2>();
        posList.add(new Vector2(0.0f, 0.0f));
        for (int i = 0; i < collegeSettings.getInt("numBuildings"); ++i) {
            Vector2 pos = Utilities.randomPos(-radius, radius);
            if (posList.contains(pos = Utilities.floor(pos))) continue;
            posList.add(pos);
            pos = Utilities.tilesToDistance(pos).add(origin);
            Building b = new Building();
            this.buildings.add(b);
            String b_name = Utilities.randomChoice(buildingNames, 0);
            b.create(pos, b_name);
        }
        Building flag = new Building(true);
        this.buildings.add(flag);
        flag.create(origin, colour);
    }

    public boolean isAlive() {
        boolean res = false;
        for (int i = 0; i < this.buildings.size() - 1; ++i) {
            Building b = this.buildings.get(i);
            if (!b.isAlive()) continue;
            res = true;
        }
        if (!res) {
            if (this.getComponent(Pirate.class).isAlive()) {
                GameManager.getPlayer().getComponent(Pirate.class).addPoints(10000);
                GameManager.getPlayer().getComponent(Pirate.class).addPlunder(1000);
                this.active = false;
            }
            this.getComponent(Pirate.class).kill();
        }
        return res;
    }

    public void kill() {
        for (int i = 0; i < this.buildings.size() - 1; ++i) {
            Building b = this.buildings.get(i);
            b.destroy();
        }
        this.active = false;
    }

    public void shoot(Vector2 target) {
        GameManager.shoot2(this, target);
    }

    public Vector2 getPosition() {
        return this.getComponent(Transform.class).getPosition().cpy();
    }

    @Override
    public void update() {
        super.update();
        this.isAlive();
        if (this.getComponent(Pirate.class).getFaction() == GameManager.getPlayer().getComponent(Pirate.class).getFaction()) {
            return;
        }
        if (this.active) {
            if (this.i == 50) {
                this.target = new Vector2(-1.0f * (this.getPosition().x - GameManager.ships.get((int)0).getPosition().x), -1.0f * (this.getPosition().y - GameManager.ships.get((int)0).getPosition().y));
                this.shoot(this.target);
                this.i = 0;
            }
            ++this.i;
        }
    }
}

