/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.College;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Managers.EntityManager;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.game.Physics.PhysicsBodyType;
import com.mygdx.utils.Constants;

public class CannonBallCollege
extends Entity
implements CollisionCallBack {
    private static float speed;
    private boolean toggleLife;
    private static final int MAX_AGE = 5;
    private College shooter;

    public CannonBallCollege() {
        super(3);
        this.setName("ball");
        this.toggleLife = false;
        Transform t = new Transform();
        t.setPosition(-100.0f, 100.0f);
        t.setScale(0.5f, 0.5f);
        Renderable r = Application.ApplicationType.HeadlessDesktop == Gdx.app.getType() ? new Renderable() : new Renderable(4, "ball", RenderLayer.Transparent);
        RigidBody rb = new RigidBody(PhysicsBodyType.Dynamic, r, t, true);
        rb.setCallback(this);
        this.addComponents(t, r, rb);
        speed = GameManager.getSettings().get("starting").getFloat("cannonSpeed");
        r.hide();
    }

    @Override
    public void update() {
        super.update();
        this.removeOnCollision();
    }

    private void removeOnCollision() {
        if (this.toggleLife) {
            this.getComponent(Renderable.class).hide();
            Transform t = this.getComponent(Transform.class);
            t.setPosition(10000.0f, 10000.0f);
            RigidBody rb = this.getComponent(RigidBody.class);
            rb.setPosition(t.getPosition());
            rb.setVelocity(0.0f, 0.0f);
            this.toggleLife = false;
        }
    }

    public void fire(Vector2 pos, Vector2 dir, College sender) {
        Transform t = this.getComponent(Transform.class);
        t.setPosition(pos);
        RigidBody rb = this.getComponent(RigidBody.class);
        Vector2 ta = dir.cpy().scl(speed * EntityManager.getDeltaTime());
        Vector2 o = new Vector2(Constants.TILE_SIZE * t.getScale().x, Constants.TILE_SIZE * t.getScale().y);
        Vector2 v = ta.cpy().sub(o);
        rb.setVelocity(v);
        this.getComponent(Renderable.class).show();
        this.shooter = sender;
    }

    public void kill() {
        this.toggleLife = true;
    }

    public College getShooter() {
        return this.shooter;
    }

    @Override
    public void BeginContact(CollisionInfo info) {
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
    }
}

