/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.CannonBall;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.game.Physics.PhysicsBodyType;

public class Building
extends Entity
implements CollisionCallBack {
    private String buildingName;
    private static int atlas_id;
    private boolean isFlag = false;

    public Building() {
        Renderable r;
        Transform t = new Transform();
        t.setScale(1.5f, 1.5f);
        Pirate p = new Pirate();
        if (Application.ApplicationType.HeadlessDesktop == Gdx.app.getType()) {
            r = new Renderable();
        } else {
            atlas_id = ResourceManager.getId("Buildings.txt");
            r = new Renderable(atlas_id, "big", RenderLayer.Transparent);
        }
        this.addComponents(t, p, r);
    }

    public Building(boolean isFlag) {
        this();
        this.isFlag = isFlag;
    }

    public void create(Vector2 pos, String name) {
        Renderable r = this.getComponent(Renderable.class);
        if (Application.ApplicationType.HeadlessDesktop != Gdx.app.getType()) {
            Sprite s = ResourceManager.getSprite(atlas_id, name);
            r.setTexture(s);
        }
        this.getComponent(Transform.class).setPosition(pos);
        this.buildingName = name;
        RigidBody rb = new RigidBody(PhysicsBodyType.Static, r, this.getComponent(Transform.class));
        rb.setCallback(this);
        this.addComponent(rb);
    }

    public void destroy() {
        if (this.isFlag) {
            return;
        }
        if (Application.ApplicationType.HeadlessDesktop != Gdx.app.getType()) {
            Sprite s = ResourceManager.getSprite(atlas_id, this.buildingName + "-broken");
            Renderable r = this.getComponent(Renderable.class);
            r.setTexture(s);
        }
        this.getComponent(Pirate.class).kill();
    }

    public boolean isAlive() {
        return this.getComponent(Pirate.class).isAlive();
    }

    @Override
    public void BeginContact(CollisionInfo info) {
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
        if (info.a instanceof CannonBall && this.isAlive()) {
            CannonBall b = (CannonBall)info.a;
            this.destroy();
            ((CannonBall)info.a).kill();
        }
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
    }
}

