/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.RenderingManager;

public class Text
extends Component {
    BitmapFont font;
    Vector3 fontColour;
    Vector2 position = new Vector2();
    Vector2 offset = new Vector2();
    String text;

    public Text() {
        this.type = ComponentType.Text;
    }

    public Text(Vector3 fontColour) {
        this();
        this.font = new BitmapFont();
        this.fontColour = fontColour;
        RenderingManager.addItem(this, RenderLayer.Transparent);
    }

    public void setPosition(Vector2 pos) {
        this.position.set(pos);
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    public void setFontColour(Vector3 col) {
        this.fontColour.set(col);
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void update() {
        super.update();
        Transform t = this.parent.getComponent(Transform.class);
        if (t == null) {
            return;
        }
        this.position.set(t.getPosition());
    }

    @Override
    public void render() {
        super.render();
        Color c = new Color();
        c.r = this.fontColour.x;
        c.g = this.fontColour.y;
        c.b = this.fontColour.z;
        c.a = 1.0f;
        this.font.setColor(c);
        float x = this.position.x + this.offset.x;
        float y = this.position.y + this.font.getXHeight() * 2.0f + this.offset.x;
        this.font.draw((Batch)RenderingManager.getBatch(), this.text, x, y);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }
}

