/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.RenderingManager;
import com.mygdx.game.Managers.ResourceManager;

public class Renderable
extends Component {
    protected Sprite sprite;
    private boolean isVisible = true;

    public Renderable() {
        this.type = ComponentType.Renderable;
        this.sprite = new Sprite();
        RenderingManager.addItem(this, RenderLayer.Transparent);
    }

    public Renderable(int texId, RenderLayer layer) {
        this();
        this.sprite = new Sprite(ResourceManager.getTexture(texId));
        RenderingManager.addItem(this, layer);
    }

    public Renderable(int atlasId, String texName, RenderLayer layer) {
        this();
        this.sprite = new Sprite(ResourceManager.getSprite(atlasId, texName));
        RenderingManager.addItem(this, layer);
    }

    public Renderable(String img, RenderLayer layer) {
        this();
        Texture texture = new Texture(img);
        this.sprite = new Sprite(texture);
        RenderingManager.addItem(this, layer);
    }

    @Override
    public void update() {
        super.update();
        if (this.sprite == null) {
            return;
        }
        Transform c = this.parent.getComponent(Transform.class);
        if (c == null) {
            return;
        }
        Vector2 p = c.getPosition();
        Vector2 s = c.getScale();
        this.sprite.setPosition(p.x, p.y);
        this.sprite.setRotation(57.295776f * c.getRotation());
        this.sprite.setScale(s.x, s.y);
    }

    @Override
    public void render() {
        super.render();
        if (this.sprite == null || !this.isVisible) {
            return;
        }
        this.sprite.draw(RenderingManager.getBatch());
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void setTexture(Sprite s) {
        Sprite a = this.getSprite();
        a.setTexture(s.getTexture());
        a.setU(s.getU());
        a.setV(s.getV());
        a.setU2(s.getU2());
        a.setV2(s.getV2());
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void show() {
        this.isVisible = true;
    }

    public void hide() {
        this.isVisible = false;
    }

    public void toggleVisibility() {
        this.isVisible = !this.isVisible;
    }
}

