/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Faction;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.utils.QueueFIFO;

public class Pirate
extends Component {
    private int factionId;
    public static int plunder;
    protected boolean isAlive;
    public int health;
    public int points;
    public static int ammo;
    private final int attackDmg;
    public boolean isImmortality;
    public boolean isUnlimitedAmmo;
    public boolean isShootEightDirections;
    public boolean isBiggerDamage;
    private final QueueFIFO<Ship> targets = new QueueFIFO();

    public Pirate() {
        this.type = ComponentType.Pirate;
        plunder = GameManager.getSettings().get("starting").getInt("plunder");
        this.factionId = 1;
        this.isAlive = true;
        JsonValue starting = GameManager.getSettings().get("starting");
        this.health = starting.getInt("health");
        this.attackDmg = starting.getInt("damage");
        ammo = starting.getInt("ammo");
        this.health = starting.getInt("health");
        this.isUnlimitedAmmo = false;
        this.isImmortality = false;
        this.isShootEightDirections = false;
        this.isBiggerDamage = false;
        this.points = 0;
    }

    public void addTarget(Ship target) {
        this.targets.add(target);
    }

    public int getPlunder() {
        return plunder;
    }

    public void addPlunder(int money) {
        plunder += money;
    }

    public Faction getFaction() {
        return GameManager.getFaction(this.factionId);
    }

    public void setFactionId(int factionId) {
        this.factionId = factionId;
    }

    public void setImmortality(boolean state) {
        this.isImmortality = state;
    }

    public boolean getImmortality() {
        return this.isImmortality;
    }

    public void setUnlimitedAmmo(boolean state) {
        this.isUnlimitedAmmo = state;
    }

    public boolean getUnlimitedAmmo() {
        return this.isUnlimitedAmmo;
    }

    public void setShootEightDirections(boolean state) {
        this.isShootEightDirections = state;
    }

    public boolean getShootEightDirections() {
        return this.isShootEightDirections;
    }

    public void setBiggerDamage(boolean state) {
        this.isBiggerDamage = state;
    }

    public boolean getBiggerDamage() {
        return this.isBiggerDamage;
    }

    public void takeDamage(float dmg) {
        if (this.isImmortality) {
            dmg = 0.0f;
        }
        this.health = (int)((float)this.health - dmg);
        if (this.health <= 0) {
            this.health = 0;
            this.isAlive = false;
        }
    }

    public void shoot(Vector2 dir) {
        if (ammo == 0) {
            return;
        }
        if (!this.isUnlimitedAmmo) {
            --ammo;
        }
        if (!this.isShootEightDirections) {
            GameManager.shoot((Ship)this.parent, dir);
        } else {
            GameManager.shoot((Ship)this.parent, new Vector2(0.0f, 1.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(0.0f, -1.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(1.0f, 0.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(-1.0f, 0.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(1.0f, 1.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(-1.0f, 1.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(1.0f, -1.0f));
            GameManager.shoot((Ship)this.parent, new Vector2(-1.0f, -1.0f));
        }
    }

    public static void addAmmo(int newAmmo) {
        ammo += newAmmo;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int overrideHealth) {
        this.health = overrideHealth;
    }

    public boolean canAttack() {
        if (this.targets.peek() != null) {
            Ship p = (Ship)this.parent;
            Vector2 pos = p.getPosition();
            float dst = pos.dst(this.targets.peek().getPosition());
            return dst < Ship.getAttackRange();
        }
        return false;
    }

    public boolean isAgro() {
        if (this.targets.peek() != null) {
            Ship p = (Ship)this.parent;
            Vector2 pos = p.getPosition();
            float dst = pos.dst(this.targets.peek().getPosition());
            return dst >= Ship.getAttackRange();
        }
        return false;
    }

    public Ship getTarget() {
        return this.targets.peek();
    }

    public void removeTarget() {
        this.targets.pop();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void kill() {
        this.health = 0;
        this.isAlive = false;
    }

    public void setAmmo(int ammo) {
        Pirate.ammo = ammo;
    }

    public int getAmmo() {
        return ammo;
    }

    public int targetCount() {
        return this.targets.size();
    }

    public QueueFIFO<Ship> getTargets() {
        return this.targets;
    }

    public int getPoints() {
        return this.points;
    }

    public void addPoints(int value) {
        this.points += value;
    }
}

