/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Managers.EntityManager;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Component {
    protected ComponentType type = ComponentType.Unknown;
    protected Entity parent = null;
    protected ArrayList<ComponentType> requirements = new ArrayList();
    protected boolean reqsMet = false;

    protected Component() {
        EntityManager.addComponent(this);
    }

    public void setParent(Entity e) {
        this.parent = e;
    }

    public Entity getParent() {
        return this.parent;
    }

    public final void setRequirements(ComponentType ... reqs) {
        this.requirements.addAll(Arrays.asList(reqs));
    }

    private void checkRequirements() {
        if (this.reqsMet) {
            return;
        }
        for (ComponentType t : this.requirements) {
            Component c = this.parent.getComponent(t);
            if (c != null) continue;
            throw new RuntimeException("Component: " + t.name() + " Is not found for " + this.type.name());
        }
        this.reqsMet = true;
    }

    public final ComponentType getType() {
        return this.type;
    }

    public void awake() {
        this.checkRequirements();
    }

    public void start() {
        this.checkRequirements();
    }

    public void cleanUp() {
        this.checkRequirements();
    }

    public void update() {
        this.checkRequirements();
    }

    public void render() {
        this.checkRequirements();
    }
}

