/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.AI;

import com.badlogic.gdx.ai.pfa.Connection;
import com.badlogic.gdx.ai.pfa.DefaultGraphPath;
import com.badlogic.gdx.ai.pfa.GraphPath;
import com.badlogic.gdx.ai.pfa.indexed.IndexedAStarPathFinder;
import com.badlogic.gdx.ai.pfa.indexed.IndexedGraph;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.mygdx.game.AI.Node;
import com.mygdx.game.AI.NodeHeuristic;
import com.mygdx.game.AI.Path;
import com.mygdx.utils.QueueFIFO;
import com.mygdx.utils.TileMapCells;

public class TileMapGraph
implements IndexedGraph<Node> {
    private final NodeHeuristic heuristic = new NodeHeuristic();
    private final Array<Node> nodes = new Array();
    private final Array<Path> paths = new Array();
    private final Vector2 mapDim;
    private final ObjectMap<Node, Array<Connection<Node>>> nodePaths = new ObjectMap();

    private TileMapGraph() {
        this.mapDim = new Vector2();
    }

    public TileMapGraph(TiledMap map) {
        this();
        MapLayers layers = map.getLayers();
        TiledMapTileLayer layer = null;
        for (MapLayer l : layers) {
            if (!l.getName().equals("Collision")) continue;
            layer = (TiledMapTileLayer)l;
        }
        if (layer == null) {
            return;
        }
        this.mapDim.set(layer.getWidth(), layer.getHeight());
        this.nodes.ensureCapacity((int)this.mapDim.x * (int)this.mapDim.y);
        int i = 0;
        while ((float)i < this.mapDim.x * this.mapDim.y) {
            this.nodes.add(new Node(0.0f, 0.0f));
            ++i;
        }
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                TiledMapTileLayer.Cell center = layer.getCell(x, y);
                if (this.getType(center) == TileMapCells.OBSTACLE) continue;
                this.addNode(x, y);
                for (int i2 = -1; i2 < 2; ++i2) {
                    for (int j = -1; j < 2; ++j) {
                        TiledMapTileLayer.Cell cell;
                        if (i2 == 0 && j == 0 || (cell = layer.getCell(x + i2, y + j)) == null || cell.getTile().getId() != TileMapCells.PASSABLE) continue;
                        this.addNode(x + i2, y + j);
                        this.addPath(x, y, x + i2, y + j);
                    }
                }
            }
        }
    }

    public Node getNode(float x, float y) {
        Node n = this.nodes.get(this.getIndex(x, y));
        if (n.cost == -1.0f) {
            return null;
        }
        return n;
    }

    private int getIndex(float x, float y) {
        return (int)(this.mapDim.x * y + x);
    }

    private int getType(TiledMapTileLayer.Cell c) {
        return c.getTile().getId();
    }

    private int getIndex(int x, int y) {
        return (int)this.mapDim.x * y + x;
    }

    private void addNode(float x, float y) {
        Node n = this.nodes.get(this.getIndex((int)x, (int)y));
        if (n.cost > 0.0f) {
            return;
        }
        n.set(x, y);
        n.cost = 1.0f;
    }

    private void addPath(Node a, Node b) {
        Path path = new Path(a, b);
        if (!this.nodePaths.containsKey(a)) {
            this.nodePaths.put(a, new Array());
        }
        this.nodePaths.get(a).add(path);
        this.paths.add(path);
    }

    private void addPath(float x1, float y1, float x2, float y2) {
        Node a = this.getNode(x1, y1);
        Node b = this.getNode(x2, y2);
        this.addPath(a, b);
    }

    public GraphPath<Node> findPath(Node start, Node goal) {
        if (start == null || goal == null) {
            return null;
        }
        DefaultGraphPath<Node> path = new DefaultGraphPath<Node>();
        new IndexedAStarPathFinder<Node>(this).searchNodePath(start, goal, this.heuristic, path);
        return path;
    }

    public QueueFIFO<Vector2> findOptimisedPath(Node a, Node b) {
        GraphPath<Node> path = this.findPath(a, b);
        QueueFIFO<Vector2> res = new QueueFIFO<Vector2>();
        Vector2 delta = new Vector2();
        float sequenceLength = 0.0f;
        Vector2 cur = new Vector2();
        Vector2 prev = path.get(0).getPosition();
        for (int i = 1; i < path.getCount(); ++i) {
            Node n = path.get(i);
            cur.set(n.getPosition());
            Vector2 d = cur.cpy();
            d.sub(prev);
            if (delta.x == d.x && delta.y == d.y) {
                sequenceLength += 1.0f;
            } else {
                res.add(delta.scl(sequenceLength));
                delta = d;
                sequenceLength = 1.0f;
            }
            prev.set(cur);
        }
        res.remove(0);
        res.add(delta.scl(sequenceLength));
        return res;
    }

    public QueueFIFO<Vector2> findOptimisedPath(Vector2 a, Vector2 b) {
        Node n1 = this.getNode(a.x, a.y);
        Node n2 = this.getNode(b.x, b.y);
        return this.findOptimisedPath(n1, n2);
    }

    public QueueFIFO<Vector2> findOptimisedPath(float x1, float y1, float x2, float y2) {
        Node a = this.getNode(x1, y1);
        Node b = this.getNode(x2, y2);
        return this.findOptimisedPath(a, b);
    }

    @Override
    public int getIndex(Node node) {
        return this.getIndex(node.getPosition().x, node.getPosition().y);
    }

    @Override
    public int getNodeCount() {
        return (int)(this.mapDim.x * this.mapDim.y);
    }

    @Override
    public Array<Connection<Node>> getConnections(Node fromNode) {
        if (this.nodePaths.containsKey(fromNode)) {
            return this.nodePaths.get(fromNode);
        }
        return new Array<Connection<Node>>();
    }
}

