/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.AI;

import com.badlogic.gdx.ai.fsm.State;
import com.badlogic.gdx.ai.fsm.StateMachine;
import com.badlogic.gdx.ai.msg.Telegram;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Entitys.NPCShip;

public enum EnemyState implements State<NPCShip>
{
    WANDER{

        @Override
        public void enter(NPCShip e) {
            e.stopMovement();
            e.wander();
        }

        @Override
        public void update(NPCShip e) {
            super.update(e);
        }
    }
    ,
    PURSUE{

        @Override
        public void enter(NPCShip e) {
            e.followTarget();
        }

        @Override
        public void update(NPCShip e) {
            super.update(e);
        }
    }
    ,
    HUNT{

        @Override
        public void update(NPCShip e) {
            super.update(e);
        }
    }
    ,
    ATTACK{

        @Override
        public void enter(NPCShip e) {
            e.stopMovement();
        }

        @Override
        public void update(NPCShip e) {
            super.update(e);
        }
    };


    @Override
    public void update(NPCShip e) {
        StateMachine<NPCShip, EnemyState> m = e.stateMachine;
        Pirate p = e.getComponent(Pirate.class);
        switch (m.getCurrentState()) {
            case WANDER: {
                if (p.isAgro()) {
                    m.changeState(PURSUE);
                    break;
                }
                if (!p.canAttack()) break;
                m.changeState(ATTACK);
                break;
            }
            case PURSUE: {
                if (p.canAttack()) {
                    m.changeState(ATTACK);
                }
                if (p.canAttack() || p.isAgro()) break;
                m.changeState(WANDER);
                break;
            }
            case HUNT: {
                if (!p.isAgro()) break;
                m.changeState(PURSUE);
                break;
            }
            case ATTACK: {
                if (p.isAgro() && !p.canAttack()) {
                    m.changeState(PURSUE);
                    break;
                }
                if (p.getTarget().isAlive()) break;
                m.changeState(WANDER);
            }
        }
    }

    @Override
    public void exit(NPCShip e) {
    }

    @Override
    public void enter(NPCShip entity) {
    }

    @Override
    public boolean onMessage(NPCShip e, Telegram telegram) {
        return false;
    }
}

