/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.mygdx.utils.Constants;
import java.util.ArrayList;
import java.util.Random;

public final class Utilities {
    public static float vectorToAngle(Vector2 v) {
        return (float)Math.atan2(-v.x, v.y);
    }

    public static Vector2 angleToVector(Vector2 out, float angle) {
        out.x = -((float)Math.sin(angle));
        out.y = (float)Math.cos(angle);
        return out;
    }

    public static float tilesToDistance(float tiles) {
        return Constants.TILE_SIZE * tiles;
    }

    public static Vector2 tilesToDistance(Vector2 tiles) {
        return tiles.cpy().scl(Constants.TILE_SIZE);
    }

    public static int distanceToTiles(float dist) {
        return (int)(dist / Constants.TILE_SIZE);
    }

    public static Vector2 distanceToTiles(Vector2 dist) {
        return dist.cpy().scl(1.0f / Constants.TILE_SIZE);
    }

    public static boolean checkProximity(Vector2 a, Vector2 b, float radius) {
        float d2 = radius * radius;
        float d = Math.abs(a.dst2(b));
        return d < d2;
    }

    public static float angleBetween(Vector2 v, Vector2 w) {
        return MathUtils.atan2(w.y * v.x - w.x * v.y, w.x * v.x + w.y * v.y);
    }

    public static float scale(float x, float min0, float max0, float min1, float max1) {
        return (max1 - min1) * ((x - min0 * x) / (max0 * x - min0 * x)) + min1;
    }

    public static float scale(float x, Vector2 a, Vector2 b) {
        return (b.y - b.x) * ((x - a.x * x) / (a.y * x - a.x * x)) + b.x;
    }

    public static Vector2 round(Vector2 x) {
        x.x = Math.round(x.x);
        x.y = Math.round(x.y);
        return x;
    }

    public static Vector2 randomPos(float min, float max) {
        Random r = new Random();
        return new Vector2(min + r.nextFloat() * (max - min), min + r.nextFloat() * (max - min));
    }

    public static <T> T randomChoice(ArrayList<T> list, Integer choice) {
        choice = new Random().nextInt(list.size());
        return list.get(choice);
    }

    public static Vector2 floor(Vector2 a) {
        return new Vector2(MathUtils.floor(a.x), MathUtils.floor(a.y));
    }

    public static void print(String v, String eol) {
        System.out.print(v + eol);
    }

    public static void print(String v) {
        System.out.println(v);
    }

    public static <T> boolean contains(ArrayList<T> array, T a) {
        for (T b : array) {
            if (b != a) continue;
            return true;
        }
        return false;
    }
}

