/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.UI;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.utils.ScreenUtils;
import com.mygdx.game.Components.ComponentEvent;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Managers.EntityManager;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.PhysicsManager;
import com.mygdx.game.Managers.QuestManager;
import com.mygdx.game.Managers.RenderingManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.PirateGame;
import com.mygdx.game.Quests.Quest;
import com.mygdx.game.UI.Page;
import com.mygdx.utils.Constants;

public class GameScreen
extends Page {
    private Label healthLabel;
    private Label dosh;
    private Label ammo;
    private final Label questDesc;
    private final Label questName;
    private float accumulator;

    public GameScreen(PirateGame parent, int id_map) {
        super(parent);
        Constants.INIT_CONSTANTS();
        PhysicsManager.Initialize(false);
        GameManager.SpawnGame(id_map);
        EntityManager.raiseEvents(ComponentEvent.Awake, ComponentEvent.Start);
        Window questWindow = new Window("Current Quest", parent.skin);
        Quest q = QuestManager.currentQuest();
        Table t = new Table();
        this.questName = new Label((CharSequence)"NAME", parent.skin);
        t.add(this.questName);
        t.row();
        this.questDesc = new Label((CharSequence)"DESCRIPTION", parent.skin);
        if (q != null) {
            this.questName.setText(q.getName());
            this.questDesc.setText(q.getDescription());
        }
        t.add(this.questDesc).left();
        questWindow.add(t);
        this.actors.add(questWindow);
        Table t1 = new Table();
        t1.top().right();
        t1.setFillParent(true);
        this.actors.add(t1);
        Window tutWindow = new Window("Controls", parent.skin);
        Table table = new Table();
        tutWindow.add(table);
        t1.add(tutWindow);
        table.add(new Label((CharSequence)"Move with", parent.skin)).top().left();
        table.add(new Image(parent.skin, "key-w"));
        table.add(new Image(parent.skin, "key-s"));
        table.add(new Image(parent.skin, "key-a"));
        table.add(new Image(parent.skin, "key-d"));
        table.row();
        table.add(new Label((CharSequence)"Shoot in direction of mouse", parent.skin)).left();
        table.add(new Image(parent.skin, "mouse"));
        table.row();
        table.add(new Label((CharSequence)"Shoot in direction of ship", parent.skin)).left();
        table.add(new Image(parent.skin, "space"));
        table.row();
        table.add(new Label((CharSequence)"Quit", parent.skin)).left();
        table.add(new Image(parent.skin, "key-esc"));
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(Constants.BACKGROUND_COLOUR.x, Constants.BACKGROUND_COLOUR.y, Constants.BACKGROUND_COLOUR.z, 1.0f);
        EntityManager.raiseEvents(ComponentEvent.Update, ComponentEvent.Render);
        this.accumulator += EntityManager.getDeltaTime();
        while (this.accumulator >= Constants.PHYSICS_TIME_STEP) {
            PhysicsManager.update();
            this.accumulator -= Constants.PHYSICS_TIME_STEP;
        }
        GameManager.update();
        if (Gdx.input.isKeyJustPressed(111)) {
            this.parent.setScreen(this.parent.end);
        }
        super.render(delta);
    }

    @Override
    public void dispose() {
        super.dispose();
        ResourceManager.cleanUp();
        EntityManager.cleanUp();
        RenderingManager.cleanUp();
        PhysicsManager.cleanUp();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        OrthographicCamera cam = RenderingManager.getCamera();
        cam.viewportWidth = (float)width / 2.15f;
        cam.viewportHeight = (float)height / 2.15f;
        cam.update();
    }

    @Override
    protected void update() {
        super.update();
        Player p = GameManager.getPlayer();
        this.healthLabel.setText(String.valueOf(p.getHealth()));
        this.dosh.setText(String.valueOf(p.getPlunder()));
        this.ammo.setText(String.valueOf(p.getAmmo()));
        if (!QuestManager.anyQuests()) {
            this.parent.end.win();
            this.parent.setScreen(this.parent.end);
        } else {
            Quest q = QuestManager.currentQuest();
            this.questName.setText(q.getName());
            this.questDesc.setText(q.getDescription());
        }
    }

    @Override
    protected void CreateActors() {
        Table table = new Table();
        table.setFillParent(true);
        this.actors.add(table);
        table.add(new Image(this.parent.skin.getDrawable("heart"))).top().left().size(1.25f * Constants.TILE_SIZE);
        this.healthLabel = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(this.healthLabel).top().left().size(50.0f);
        table.row();
        table.setDebug(false);
        table.add(new Image(this.parent.skin.getDrawable("coin"))).top().left().size(1.25f * Constants.TILE_SIZE);
        this.dosh = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(this.dosh).top().left().size(50.0f);
        table.row();
        table.add(new Image(this.parent.skin.getDrawable("ball"))).top().left().size(1.25f * Constants.TILE_SIZE);
        this.ammo = new Label((CharSequence)"N/A", this.parent.skin);
        table.add(this.ammo).top().left().size(50.0f);
        table.top().left();
    }
}

