/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Quests;

import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Quests.Quest;
import com.mygdx.utils.Constants;

public class LocateQuest
extends Quest {
    private final Vector2 loc;
    private float radius;

    public LocateQuest() {
        this.name = "Find a chest";
        this.description = "North east";
        this.reward = 100;
        this.loc = new Vector2();
        this.radius = -1.0f;
    }

    public LocateQuest(Vector2 pos, float r) {
        this();
        this.loc.set(pos);
        this.radius = r * r;
        pos.scl(1.0f / Constants.TILE_SIZE).sub(50.0f, 50.0f);
        this.description = "";
        if (pos.y > 0.0f) {
            this.description = this.description + "North ";
        } else if (pos.y < 0.0f) {
            this.description = this.description + "South ";
        }
        if (pos.x > 0.0f) {
            this.description = this.description + "East";
        } else if (pos.x < 0.0f) {
            this.description = this.description + "West";
        }
    }

    @Override
    public boolean checkCompleted(Player p) {
        if (this.radius == -1.0f) {
            return false;
        }
        Vector2 delta = p.getPosition().cpy();
        delta.sub(this.loc);
        float l = delta.len2();
        this.isCompleted = l < this.radius;
        return this.isCompleted;
    }

    public Vector2 getLocation() {
        return this.loc;
    }
}

