/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Entitys.Building;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.utils.Constants;
import java.util.ArrayList;

public final class RenderingManager {
    private static boolean initialized = false;
    private static ArrayList<Component> renderItems;
    private static ArrayList<ArrayList<Integer>> layers;
    private static OrthographicCamera camera;
    private static SpriteBatch batch;

    public static void Initialize() {
        initialized = true;
        renderItems = new ArrayList();
        batch = new SpriteBatch();
        camera = new OrthographicCamera();
        RenderingManager.camera.viewportHeight = (float)Constants.VIEWPORT_HEIGHT / 2.15f;
        RenderingManager.camera.viewportWidth = (float)Constants.VIEWPORT_WIDTH / 2.15f;
        camera.update();
        layers = new ArrayList(RenderLayer.values().length);
        for (int i = 0; i < RenderLayer.values().length; ++i) {
            layers.add(new ArrayList());
        }
    }

    public static OrthographicCamera getCamera() {
        return camera;
    }

    public static void setCamera(OrthographicCamera cam) {
        camera = cam;
    }

    public static void addItem(Component item, RenderLayer layer) {
        RenderingManager.tryInit();
        renderItems.add(item);
        layers.get(layer.ordinal()).add(renderItems.size() - 1);
    }

    private static void tryInit() {
        if (!initialized) {
            RenderingManager.Initialize();
        }
    }

    public static void render() {
        RenderingManager.tryInit();
        batch.setProjectionMatrix(RenderingManager.camera.combined);
        batch.begin();
        for (ArrayList<Integer> layer : layers) {
            for (Integer itemIndex : layer) {
                Component item = renderItems.get(itemIndex);
                if (item.getParent() instanceof Building) {
                    boolean bl = false;
                }
                item.render();
            }
        }
        batch.end();
    }

    public static void cleanUp() {
        batch.dispose();
    }

    public static SpriteBatch getBatch() {
        return batch;
    }
}

