/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Entitys.Chest;
import com.mygdx.game.Entitys.College;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Quests.KillQuest;
import com.mygdx.game.Quests.LocateQuest;
import com.mygdx.game.Quests.Quest;
import com.mygdx.utils.Constants;
import com.mygdx.utils.Utilities;
import java.util.ArrayList;
import java.util.Random;

public class QuestManager {
    private static boolean initialized = false;
    private static ArrayList<Quest> allQuests;
    private static Chest chest;

    public static void Initialize() {
        initialized = true;
        allQuests = new ArrayList();
        chest = new Chest();
        QuestManager.createRandomQuests();
    }

    private static int rndKillQuest(ArrayList<Integer> exclude) {
        College enemy;
        int id;
        int i = 0;
        do {
            id = new Random().nextInt(4) + 2;
            enemy = GameManager.getCollege(id);
        } while (Utilities.contains(exclude, id) && ++i < 5);
        if (i == 5) {
            return 0;
        }
        QuestManager.addQuest(new KillQuest(enemy));
        return id;
    }

    private static void rndLocateQuest() {
        float y;
        ArrayList<Float> locations = new ArrayList<Float>();
        for (float f : GameManager.getSettings().get("quests").get("locations").asFloatArray()) {
            locations.add(Float.valueOf(f));
        }
        Integer choice = -1;
        float x = ((Float)Utilities.randomChoice(locations, choice)).floatValue();
        assert (choice > -1);
        if (choice == locations.size() - 1) {
            y = x;
            x = ((Float)locations.get(choice - 1)).floatValue();
        } else {
            y = ((Float)locations.get(choice + 1)).floatValue();
        }
        QuestManager.addQuest(new LocateQuest(new Vector2(x *= Constants.TILE_SIZE, y *= Constants.TILE_SIZE), 5.0f * Constants.TILE_SIZE));
    }

    private static void rndQuest(ArrayList<Integer> exclude) {
        Random random = new Random();
        if ((double)random.nextFloat() > 0.5) {
            QuestManager.rndLocateQuest();
        } else {
            exclude.add(QuestManager.rndKillQuest(exclude));
        }
    }

    private static void createRandomQuests() {
        int primaryEnemyId = new Random().nextInt(4) + 2;
        ArrayList<Integer> exclude = new ArrayList<Integer>();
        exclude.add(primaryEnemyId);
        for (int i = 0; i < GameManager.getSettings().get("quests").getInt("count"); ++i) {
            QuestManager.rndQuest(exclude);
        }
        College enemy = GameManager.getCollege(primaryEnemyId);
        QuestManager.addQuest(new KillQuest(enemy));
    }

    public static void addQuest(Quest q) {
        QuestManager.tryInit();
        allQuests.add(q);
    }

    public static void checkCompleted() {
        QuestManager.tryInit();
        Player p = GameManager.getPlayer();
        for (Quest q : allQuests) {
            if (q.isCompleted()) continue;
            boolean completed = q.checkCompleted(p);
            if (completed) {
                p.plunder(q.getReward());
                continue;
            }
            if (q instanceof LocateQuest) {
                chest.setPosition(((LocateQuest)q).getLocation());
                break;
            }
            chest.setPosition(new Vector2(-1000.0f, -1000.0f));
            break;
        }
    }

    private static void tryInit() {
        if (!initialized) {
            QuestManager.Initialize();
        }
    }

    public static Quest currentQuest() {
        QuestManager.tryInit();
        for (Quest q : allQuests) {
            if (q.isCompleted()) continue;
            return q;
        }
        return null;
    }

    public static boolean anyQuests() {
        QuestManager.tryInit();
        return QuestManager.currentQuest() != null;
    }
}

