/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.World;
import com.mygdx.game.Components.TileMap;
import com.mygdx.game.Managers.CollisionManager;
import com.mygdx.game.Managers.RenderingManager;
import com.mygdx.utils.Constants;
import java.util.ArrayList;
import java.util.Objects;

public final class PhysicsManager {
    private static final float TILE_SIZE_INV = 1.0f;
    public static boolean initialized = false;
    public static World box2DWorld;
    private static ArrayList<Body> box2DBodies;
    private static Box2DDebugRenderer debug;

    public static void Initialize() {
        PhysicsManager.Initialize(false);
    }

    public static void Initialize(boolean drawDebug) {
        if (initialized) {
            return;
        }
        initialized = true;
        box2DWorld = new World(new Vector2(0.0f, 0.0f), true);
        box2DBodies = new ArrayList();
        box2DWorld.setContactListener(new CollisionManager());
        if (drawDebug) {
            debug = new Box2DDebugRenderer(true, false, true, true, false, true);
        }
    }

    public static int createBody(BodyDef bDef, FixtureDef fDef, Object userData) {
        PhysicsManager.tryInit();
        bDef.fixedRotation = true;
        Body b = box2DWorld.createBody(bDef);
        b.createFixture(fDef);
        b.setUserData(userData);
        box2DBodies.add(b);
        return box2DBodies.size();
    }

    private static Shape tile_getShape(Rectangle rectangle) {
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsBox(rectangle.width * 0.5f * 1.0f, rectangle.height * 0.5f * 1.0f);
        return polygonShape;
    }

    private static Vector2 tile_getCenter(Rectangle rectangle) {
        Vector2 center = new Vector2();
        rectangle.getCenter(center);
        return center.scl(1.0f);
    }

    public static void createMapCollision(TileMap map) {
        MapLayers layers = map.getTileMap().getLayers();
        MapObjects objects = null;
        for (MapLayer layer : layers) {
            if (!Objects.equals(layer.getName(), "Objects")) continue;
            objects = layer.getObjects();
            break;
        }
        if (objects == null) {
            return;
        }
        for (MapObject object : objects) {
            Rectangle rectangle = ((RectangleMapObject)object).getRectangle();
            BodyDef bodyDef = new BodyDef();
            bodyDef.type = BodyDef.BodyType.StaticBody;
            Body body = box2DWorld.createBody(bodyDef);
            Fixture fixture = body.createFixture(PhysicsManager.tile_getShape(rectangle), 1.0f);
            fixture.setFriction(0.1f);
            body.setTransform(PhysicsManager.tile_getCenter(rectangle), 0.0f);
        }
    }

    public static Body getBody(int id) {
        return box2DBodies.get(id - 1);
    }

    private static void tryInit() {
        if (!initialized) {
            PhysicsManager.Initialize();
        }
    }

    public static void update() {
        PhysicsManager.tryInit();
        box2DWorld.step(Constants.PHYSICS_TIME_STEP, 6, 2);
        if (debug != null) {
            debug.render(box2DWorld, RenderingManager.getCamera().combined);
        }
    }

    public static void cleanUp() {
        PhysicsManager.tryInit();
        box2DWorld.dispose();
        if (debug != null) {
            debug.dispose();
        }
    }
}

