/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Managers;

import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;

public class CollisionManager
implements ContactListener {
    private static boolean initialized = false;

    public CollisionManager() {
        if (initialized) {
            throw new RuntimeException("Collision manager cant be instantiated more then once");
        }
        initialized = true;
    }

    @Override
    public void beginContact(Contact contact) {
        Fixture fa = contact.getFixtureA();
        Body ba = fa.getBody();
        Object oa = ba.getUserData();
        CollisionCallBack cbA = (CollisionCallBack)oa;
        Fixture fb = contact.getFixtureB();
        Body bb = fb.getBody();
        Object ob = bb.getUserData();
        CollisionCallBack cbB = (CollisionCallBack)ob;
        CollisionInfo info = new CollisionInfo();
        info.fA = fa;
        info.fB = fb;
        info.bA = ba;
        info.bB = bb;
        info.a = (Entity)((Object)cbA);
        info.b = (Entity)((Object)cbB);
        if (cbA != null) {
            if (fa.isSensor() && cbB != null && !fb.isSensor()) {
                cbB.EnterTrigger(info);
            } else {
                cbA.BeginContact(info);
            }
        }
        if (cbB != null) {
            if (fb.isSensor() && cbA != null && !fa.isSensor()) {
                cbA.EnterTrigger(info);
            } else {
                cbB.BeginContact(info);
            }
        }
    }

    @Override
    public void endContact(Contact contact) {
        Fixture fa = contact.getFixtureA();
        Body ba = fa.getBody();
        Object oa = ba.getUserData();
        CollisionCallBack cbA = (CollisionCallBack)oa;
        Fixture fb = contact.getFixtureB();
        Body bb = fb.getBody();
        Object ob = bb.getUserData();
        CollisionCallBack cbB = (CollisionCallBack)ob;
        CollisionInfo info = new CollisionInfo();
        info.fA = fa;
        info.fB = fb;
        info.bA = ba;
        info.bB = bb;
        info.a = (Entity)((Object)cbA);
        info.b = (Entity)((Object)cbB);
        if (cbA != null) {
            if (fa.isSensor() && cbB != null && !fb.isSensor()) {
                cbB.ExitTrigger(info);
            } else {
                cbA.EndContact(info);
            }
        }
        if (cbB != null) {
            if (fb.isSensor() && cbA != null && !fa.isSensor()) {
                cbA.ExitTrigger(info);
            } else {
                cbB.EndContact(info);
            }
        }
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }
}

