/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ObjectMap;
import com.mygdx.game.Components.Pirate;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.Entity;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.CollisionInfo;
import com.mygdx.game.Physics.PhysicsBodyType;
import com.mygdx.utils.Utilities;
import java.util.Objects;

public class Ship
extends Entity
implements CollisionCallBack {
    private static int shipCount = 0;
    public static ObjectMap<Vector2, String> shipDirections;
    private final Vector2 currentDir = new Vector2();

    public Ship() {
        super(4);
        this.setName("Ship (" + shipCount++ + ")");
        if (shipDirections == null) {
            shipDirections = new ObjectMap();
            shipDirections.put(new Vector2(0.0f, 1.0f), "-up");
            shipDirections.put(new Vector2(0.0f, -1.0f), "-down");
            shipDirections.put(new Vector2(1.0f, 0.0f), "-right");
            shipDirections.put(new Vector2(-1.0f, 0.0f), "-left");
            shipDirections.put(new Vector2(1.0f, 1.0f), "-ur");
            shipDirections.put(new Vector2(-1.0f, 1.0f), "-ul");
            shipDirections.put(new Vector2(1.0f, -1.0f), "-dr");
            shipDirections.put(new Vector2(-1.0f, -1.0f), "-dl");
        }
        Transform t = new Transform();
        t.setPosition(800.0f, 800.0f);
        Renderable r = new Renderable(3, "white-up", RenderLayer.Transparent);
        RigidBody rb = new RigidBody(PhysicsBodyType.Dynamic, r, t);
        rb.setCallback(this);
        Pirate p = new Pirate();
        this.addComponents(t, r, rb, p);
    }

    public boolean isAlive() {
        return this.getComponent(Pirate.class).getHealth() > 0;
    }

    public static float getAttackRange() {
        return Utilities.tilesToDistance(GameManager.getSettings().get("starting").getFloat("attackRange_tiles"));
    }

    public void plunder(int money) {
        this.getComponent(Pirate.class).addPlunder(money);
    }

    public void setFaction(int factionId) {
        this.getComponent(Pirate.class).setFactionId(factionId);
        this.setShipDirection("-up");
    }

    private String getShipDirection(Vector2 dir) {
        if (!this.currentDir.equals(dir) && shipDirections.containsKey(dir)) {
            this.currentDir.set(dir);
            return shipDirections.get(dir);
        }
        return "";
    }

    private String getColour() {
        return this.getComponent(Pirate.class).getFaction().getColour();
    }

    public void setShipDirection(Vector2 dir) {
        this.setShipDirection(this.getShipDirection(dir));
    }

    public void setShipDirection(String direction) {
        if (Objects.equals(direction, "")) {
            return;
        }
        Renderable r = this.getComponent(Renderable.class);
        Sprite s = ResourceManager.getSprite(3, this.getColour() + direction);
        try {
            r.setTexture(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHealth() {
        return this.getComponent(Pirate.class).getHealth();
    }

    public int getPlunder() {
        return this.getComponent(Pirate.class).getPlunder();
    }

    public void shoot(Vector2 dir) {
        this.getComponent(Pirate.class).shoot(dir);
    }

    public void shoot() {
        this.getComponent(Pirate.class).shoot(this.currentDir);
    }

    public Vector2 getPosition() {
        return this.getComponent(Transform.class).getPosition().cpy();
    }

    @Override
    public void BeginContact(CollisionInfo info) {
    }

    @Override
    public void EndContact(CollisionInfo info) {
    }

    @Override
    public void EnterTrigger(CollisionInfo info) {
        if (this instanceof Player && !(info.b instanceof Player)) {
            ((CollisionCallBack)((Object)info.b)).EnterTrigger(info);
        }
    }

    @Override
    public void ExitTrigger(CollisionInfo info) {
        if (this instanceof Player && !(info.b instanceof Player)) {
            ((CollisionCallBack)((Object)info.b)).ExitTrigger(info);
        }
    }
}

