/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Entitys;

import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentEvent;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Managers.EntityManager;
import java.util.ArrayList;

public class Entity {
    private static int entityCount = 0;
    private String entityName;
    private final ArrayList<Component> components = new ArrayList();

    public Entity() {
        this.entityName = "Entity (" + ++entityCount + ")";
        EntityManager.addEntity(this);
    }

    public Entity(int numComponents) {
        this();
        this.components.ensureCapacity(numComponents);
    }

    public final void setName(String name) {
        EntityManager.changeName(this.entityName, name);
        this.entityName = name;
    }

    public final String getName() {
        return this.entityName;
    }

    public void addComponent(Component component) {
        this.components.add(component);
        component.setParent(this);
    }

    public void addComponents(Component ... components) {
        for (Component c : components) {
            this.addComponent(c);
        }
    }

    public Component getComponent(ComponentType type) {
        for (Component c : this.components) {
            if (c.getType() != type) continue;
            return c;
        }
        return null;
    }

    public <T> T getComponent(Class<T> type) {
        for (Component c : this.components) {
            if (!type.isInstance(c)) continue;
            return (T)c;
        }
        return null;
    }

    public <T> ArrayList<T> getComponents(Class<T> type) {
        ArrayList<Component> res = new ArrayList<Component>();
        for (Component c : this.components) {
            if (!type.isInstance(c)) continue;
            res.add(c);
        }
        return res;
    }

    public final void raiseEvents(ComponentEvent ... events) {
        for (ComponentEvent event : events) {
            for (Component c : this.components) {
                switch (event) {
                    case Awake: {
                        c.awake();
                        break;
                    }
                    case Start: {
                        c.start();
                        break;
                    }
                    case Update: {
                        c.update();
                    }
                }
            }
        }
    }

    public void cleanUp() {
    }

    public void update() {
    }
}

