/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapRenderer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Managers.RenderLayer;
import com.mygdx.game.Managers.RenderingManager;
import com.mygdx.game.Managers.ResourceManager;
import com.mygdx.utils.Constants;

public class TileMap
extends Component {
    TiledMap map;
    TiledMapRenderer renderer;

    private TileMap() {
        this.type = ComponentType.TileMap;
    }

    public TileMap(int id, RenderLayer layer) {
        this();
        this.map = ResourceManager.getTileMap(id);
        this.renderer = new OrthogonalTiledMapRenderer(this.map);
        RenderingManager.addItem(this, layer);
        Constants.TILE_SIZE = this.getTileDim().x;
    }

    public TiledMapTileLayer.Cell getCell(Vector2 pos) {
        Vector2 p = pos.cpy();
        TiledMapTileLayer l = (TiledMapTileLayer)this.map.getLayers().get(1);
        p.x /= (float)l.getTileWidth();
        p.y /= (float)l.getTileHeight();
        return l.getCell((int)p.x, (int)p.y);
    }

    public Vector2 getTileDim() {
        return new Vector2(((TiledMapTileLayer)this.map.getLayers().get(0)).getTileWidth(), ((TiledMapTileLayer)this.map.getLayers().get(0)).getTileHeight());
    }

    public TiledMap getTileMap() {
        return this.map;
    }

    @Override
    public void update() {
        super.update();
        this.renderer.setView(RenderingManager.getCamera());
    }

    @Override
    public void render() {
        super.render();
        this.renderer.render(new int[]{0, 1});
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }
}

