/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Components.Renderable;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Managers.PhysicsManager;
import com.mygdx.game.Physics.CollisionCallBack;
import com.mygdx.game.Physics.PhysicsBodyType;

public class RigidBody
extends Component {
    int bodyId;
    private final Vector2 halfDim;

    public RigidBody() {
        this.type = ComponentType.RigidBody;
        this.halfDim = new Vector2();
        this.setRequirements(ComponentType.Transform, ComponentType.Renderable);
    }

    public RigidBody(PhysicsBodyType type, Renderable r, Transform t) {
        this(type, r, t, false);
    }

    public RigidBody(PhysicsBodyType type, Renderable r, Transform t, boolean isTrigger) {
        this();
        BodyDef def = new BodyDef();
        switch (type) {
            case Static: {
                def.type = BodyDef.BodyType.StaticBody;
                break;
            }
            case Dynamic: {
                def.type = BodyDef.BodyType.DynamicBody;
                break;
            }
            case Kinematic: {
                def.type = BodyDef.BodyType.KinematicBody;
            }
        }
        float h_x = r.sprite.getWidth() * 0.5f;
        float h_y = r.sprite.getHeight() * 0.5f;
        this.halfDim.set(h_x, h_y);
        def.position.set(t.getPosition().x + h_x, t.getPosition().y + h_y);
        def.angle = t.getRotation();
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(h_x *= t.getScale().x, h_y *= t.getScale().y);
        FixtureDef f = new FixtureDef();
        f.isSensor = isTrigger;
        f.shape = shape;
        f.density = type == PhysicsBodyType.Static ? 0.0f : 1.0f;
        f.restitution = 0.0f;
        f.friction = 0.0f;
        this.bodyId = PhysicsManager.createBody(def, f, null);
        shape.dispose();
    }

    public void addTrigger(float radius, Object data) {
        Body b = this.getBody();
        FixtureDef fDef = new FixtureDef();
        fDef.isSensor = true;
        CircleShape shape = new CircleShape();
        shape.setRadius(radius);
        fDef.shape = shape;
        fDef.density = 0.0f;
        fDef.restitution = 0.0f;
        fDef.friction = 0.0f;
        Fixture f = b.createFixture(fDef);
        f.setUserData(data);
    }

    public void setCallback(CollisionCallBack data) {
        this.getBody().setUserData(data);
    }

    public void setVelocity(Vector2 vel) {
        Body b = PhysicsManager.getBody(this.bodyId);
        b.setLinearVelocity(vel);
    }

    public void setVelocity(float x, float y) {
        this.setVelocity(new Vector2(x, y));
    }

    public void setPosition(Vector2 position) {
        this.setPosition(position, false);
    }

    public void setPosition(Vector2 position, boolean offset) {
        Body b = PhysicsManager.getBody(this.bodyId);
        if (offset) {
            position.add(this.halfDim);
        }
        b.setTransform(position, 0.0f);
    }

    public Body getBody() {
        return PhysicsManager.getBody(this.bodyId);
    }

    @Override
    public void update() {
        super.update();
        Transform t = this.parent.getComponent(Transform.class);
        Body b = this.getBody();
        Vector2 p = b.getPosition().cpy();
        p.sub(this.halfDim);
        t.setPosition(p, false);
    }

    public Vector2 getVelocity() {
        return this.getBody().getLinearVelocity();
    }

    public float getAngularVelocity() {
        return this.getBody().getAngularVelocity();
    }

    public void applyForce(Vector2 force) {
        this.getBody().applyForceToCenter(force, true);
    }
}

