/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Entitys.Player;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Managers.RenderingManager;
import com.mygdx.utils.Constants;

public class PlayerController
extends Component {
    private Player player;
    private float speed;

    public PlayerController() {
        this.type = ComponentType.PlayerController;
        this.setRequirements(ComponentType.RigidBody);
    }

    public PlayerController(Player player, float speed) {
        this();
        this.player = player;
        this.speed = speed;
    }

    @Override
    public void update() {
        super.update();
        float s = this.speed;
        Vector2 dir = this.getDirFromWASDInput();
        ((Ship)this.parent).setShipDirection(dir);
        dir.scl(s);
        RigidBody rb = this.parent.getComponent(RigidBody.class);
        rb.setVelocity(dir);
        RenderingManager.getCamera().position.set(new Vector3(this.player.getPosition(), 0.0f));
        RenderingManager.getCamera().update();
        if (Gdx.input.isButtonJustPressed(0)) {
            int x = Gdx.input.getX();
            int y = Gdx.input.getY();
            Vector2 delta = new Vector2(x, y);
            delta.sub(Constants.HALF_DIMENSIONS);
            delta.nor();
            delta.y *= -1.0f;
            ((Ship)this.parent).shoot(delta);
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            ((Ship)this.parent).shoot();
        }
    }

    private Vector2 getDirFromWASDInput() {
        Vector2 dir = new Vector2(0.0f, 0.0f);
        if (Gdx.input.isKeyPressed(51) || Gdx.input.isKeyPressed(19)) {
            dir.y += 1.0f;
        }
        if (Gdx.input.isKeyPressed(47) || Gdx.input.isKeyPressed(20)) {
            dir.y -= 1.0f;
        }
        if (Gdx.input.isKeyPressed(29) || Gdx.input.isKeyPressed(21)) {
            dir.x -= 1.0f;
        }
        if (Gdx.input.isKeyPressed(32) || Gdx.input.isKeyPressed(22)) {
            dir.x += 1.0f;
        }
        return dir;
    }
}

