/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Faction;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.utils.QueueFIFO;

public class Pirate
extends Component {
    private int factionId;
    private int plunder;
    protected boolean isAlive;
    private int health;
    private int ammo;
    private final int attackDmg;
    private final QueueFIFO<Ship> targets = new QueueFIFO();

    public Pirate() {
        this.type = ComponentType.Pirate;
        this.plunder = GameManager.getSettings().get("starting").getInt("plunder");
        this.factionId = 1;
        this.isAlive = true;
        JsonValue starting = GameManager.getSettings().get("starting");
        this.health = starting.getInt("health");
        this.attackDmg = starting.getInt("damage");
        this.ammo = starting.getInt("ammo");
    }

    public void addTarget(Ship target) {
        this.targets.add(target);
    }

    public int getPlunder() {
        return this.plunder;
    }

    public void addPlunder(int money) {
        this.plunder += money;
    }

    public Faction getFaction() {
        return GameManager.getFaction(this.factionId);
    }

    public void setFactionId(int factionId) {
        this.factionId = factionId;
    }

    public void takeDamage(float dmg) {
        this.health = (int)((float)this.health - dmg);
        if (this.health <= 0) {
            this.health = 0;
            this.isAlive = false;
        }
    }

    public void shoot(Vector2 dir) {
        if (this.ammo == 0) {
            return;
        }
        --this.ammo;
        GameManager.shoot((Ship)this.parent, dir);
    }

    public void reload(int ammo) {
        this.ammo += ammo;
    }

    public int getHealth() {
        return this.health;
    }

    public boolean canAttack() {
        if (this.targets.peek() != null) {
            Ship p = (Ship)this.parent;
            Vector2 pos = p.getPosition();
            float dst = pos.dst(this.targets.peek().getPosition());
            return dst < Ship.getAttackRange();
        }
        return false;
    }

    public boolean isAgro() {
        if (this.targets.peek() != null) {
            Ship p = (Ship)this.parent;
            Vector2 pos = p.getPosition();
            float dst = pos.dst(this.targets.peek().getPosition());
            return dst >= Ship.getAttackRange();
        }
        return false;
    }

    public Ship getTarget() {
        return this.targets.peek();
    }

    public void removeTarget() {
        this.targets.pop();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void kill() {
        this.health = 0;
        this.isAlive = false;
    }

    public void setAmmo(int ammo) {
        this.ammo = ammo;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public int targetCount() {
        return this.targets.size();
    }

    public QueueFIFO<Ship> getTargets() {
        return this.targets;
    }
}

