/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Components;

import com.badlogic.gdx.ai.steer.Steerable;
import com.badlogic.gdx.ai.steer.SteeringAcceleration;
import com.badlogic.gdx.ai.steer.SteeringBehavior;
import com.badlogic.gdx.ai.utils.Location;
import com.badlogic.gdx.math.Vector2;
import com.mygdx.game.Components.Component;
import com.mygdx.game.Components.ComponentType;
import com.mygdx.game.Components.RigidBody;
import com.mygdx.game.Components.Transform;
import com.mygdx.game.Entitys.Ship;
import com.mygdx.game.Managers.GameManager;
import com.mygdx.utils.Utilities;

public class AINavigation
extends Component
implements Steerable<Vector2> {
    RigidBody rb;
    Transform t;
    Attributes attributes = new Attributes();
    SteeringBehavior<Vector2> behavior;
    SteeringAcceleration<Vector2> steeringOutput;

    public AINavigation() {
        this.setRequirements(ComponentType.RigidBody);
        this.type = ComponentType.AINavigation;
        this.steeringOutput = new SteeringAcceleration<Vector2>(new Vector2());
    }

    public void setBehavior(SteeringBehavior<Vector2> behavior) {
        this.behavior = behavior;
    }

    private void getComps() {
        if (this.rb == null) {
            this.rb = this.parent.getComponent(RigidBody.class);
            this.t = this.parent.getComponent(Transform.class);
        }
    }

    @Override
    public void update() {
        super.update();
        this.getComps();
        if (this.behavior != null) {
            this.behavior.calculateSteering(this.steeringOutput);
            this.applySteering();
        } else {
            this.stop();
        }
        Vector2 vel = this.rb.getVelocity().cpy();
        if (vel.x == 0.0f && vel.y == 0.0f) {
            ((Ship)this.parent).setShipDirection("-up");
            return;
        }
        vel.nor();
        Utilities.round(vel);
        if (Ship.shipDirections.containsKey(vel)) {
            ((Ship)this.parent).setShipDirection(vel);
        }
    }

    private void applySteering() {
        Vector2 vel;
        float speed;
        boolean anyAcc = false;
        if (!((Vector2)this.steeringOutput.linear).isZero()) {
            Vector2 f = (Vector2)this.steeringOutput.linear;
            this.rb.applyForce(f);
            anyAcc = true;
        }
        if (anyAcc && (speed = (vel = this.rb.getVelocity()).len2()) > this.attributes.maxSpd * this.attributes.maxSpd) {
            this.rb.setVelocity(vel.scl(this.attributes.maxSpd / (float)Math.sqrt(speed)));
        }
    }

    public void stop() {
        this.getComps();
        this.rb.setVelocity(new Vector2(0.0f, 0.0f));
    }

    @Override
    public Vector2 getLinearVelocity() {
        this.getComps();
        return this.rb.getVelocity();
    }

    @Override
    public float getAngularVelocity() {
        this.getComps();
        return this.rb.getAngularVelocity();
    }

    @Override
    public float getBoundingRadius() {
        return this.attributes.boundingRadius;
    }

    @Override
    public boolean isTagged() {
        return this.attributes.isTagged;
    }

    @Override
    public void setTagged(boolean tagged) {
        this.attributes.isTagged = tagged;
    }

    @Override
    public float getZeroLinearSpeedThreshold() {
        return 0.01f;
    }

    @Override
    public void setZeroLinearSpeedThreshold(float value) {
    }

    @Override
    public float getMaxLinearSpeed() {
        return this.attributes.maxSpd;
    }

    @Override
    public void setMaxLinearSpeed(float maxLinearSpeed) {
        this.attributes.maxSpd = maxLinearSpeed;
    }

    @Override
    public float getMaxLinearAcceleration() {
        return this.attributes.maxAcc;
    }

    @Override
    public void setMaxLinearAcceleration(float maxLinearAcceleration) {
        this.attributes.maxAcc = maxLinearAcceleration;
    }

    @Override
    public float getMaxAngularSpeed() {
        return this.attributes.maxAngSpd;
    }

    @Override
    public void setMaxAngularSpeed(float maxAngularSpeed) {
        this.attributes.maxAngSpd = maxAngularSpeed;
    }

    @Override
    public float getMaxAngularAcceleration() {
        return this.attributes.maxAngAcc;
    }

    @Override
    public void setMaxAngularAcceleration(float maxAngularAcceleration) {
        this.attributes.maxAngAcc = maxAngularAcceleration;
    }

    @Override
    public Vector2 getPosition() {
        this.getComps();
        return this.t.getPosition();
    }

    @Override
    public float getOrientation() {
        this.getComps();
        return this.t.getRotation();
    }

    @Override
    public void setOrientation(float orientation) {
    }

    @Override
    public float vectorToAngle(Vector2 vector) {
        return Utilities.vectorToAngle(vector);
    }

    @Override
    public Vector2 angleToVector(Vector2 outVector, float angle) {
        return Utilities.angleToVector(outVector, angle);
    }

    @Override
    public Location<Vector2> newLocation() {
        this.getComps();
        return this.t;
    }

    private static class Attributes {
        public float boundingRadius = 128.0f;
        public float maxSpd = GameManager.getSettings().get("AI").getFloat("maxSpeed");
        public float maxAcc = 50000.0f;
        public float maxAngSpd = 0.0f;
        public float maxAngAcc = 0.0f;
        public boolean isTagged = false;

        private Attributes() {
        }
    }
}

